/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test.concurrent;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hive.druid.org.apache.calcite.test.concurrent.ConcurrentTestPlugin;
import org.apache.hive.druid.org.apache.calcite.test.concurrent.ConcurrentTestPluginCommand;

public class SamplePlugin
extends ConcurrentTestPlugin {
    private static final String DESCRIBE_RESULT_SET_CMD = "@describeResultSet";

    @Override
    public ConcurrentTestPluginCommand getCommandFor(String name, String params) {
        if (name.equals(DESCRIBE_RESULT_SET_CMD)) {
            return new DescribeResultSet();
        }
        assert (false);
        return null;
    }

    @Override
    public Iterable<String> getSupportedThreadCommands() {
        return Arrays.asList(DESCRIBE_RESULT_SET_CMD);
    }

    static class DescribeResultSet
    implements ConcurrentTestPluginCommand {
        DescribeResultSet() {
        }

        @Override
        public void execute(ConcurrentTestPluginCommand.TestContext testContext) throws IOException {
            PreparedStatement stmt = (PreparedStatement)testContext.getCurrentStatement();
            if (stmt == null) {
                testContext.storeMessage("No current statement");
            } else if (stmt instanceof PreparedStatement) {
                try {
                    ResultSetMetaData metadata = stmt.getMetaData();
                    for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                        testContext.storeMessage(metadata.getColumnName(i) + ": " + metadata.getColumnTypeName(i));
                    }
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e.toString());
                }
            }
        }
    }
}

