/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.plan.Context;
import org.apache.hive.druid.org.apache.calcite.plan.Contexts;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptSchema;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptSchemaWithSampling;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.prepare.Prepare;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollations;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistribution;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistributions;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.hive.druid.org.apache.calcite.rel.RelRoot;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.schema.ColumnStrategy;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParser;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.hive.druid.org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.hive.druid.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.hive.druid.org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.hive.druid.org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.hive.druid.org.apache.calcite.test.DiffRepository;
import org.apache.hive.druid.org.apache.calcite.test.MockCatalogReader;
import org.apache.hive.druid.org.apache.calcite.test.MockRelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.test.MockSqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.test.SqlToRelConverterTest;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.junit.Assert;

public abstract class SqlToRelTestBase {
    protected static final String NL = System.getProperty("line.separator");
    protected final Tester tester = this.createTester();

    protected Tester createTester() {
        return new TesterImpl(this.getDiffRepos(), false, false, true, false, null, null);
    }

    protected DiffRepository getDiffRepos() {
        return null;
    }

    public static void assertValid(RelNode rel) {
        SqlToRelConverterTest.RelValidityChecker checker = new SqlToRelConverterTest.RelValidityChecker();
        checker.go(rel);
        Assert.assertEquals((long)0L, (long)checker.invalidCount);
    }

    private static class FarragoTestValidator
    extends SqlValidatorImpl {
        FarragoTestValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
            super(opTab, catalogReader, typeFactory, conformance);
        }

        public boolean shouldExpandIdentifiers() {
            return true;
        }
    }

    public static class TesterImpl
    implements Tester {
        private RelOptPlanner planner;
        private SqlOperatorTable opTab;
        private final DiffRepository diffRepos;
        private final boolean enableDecorrelate;
        private final boolean enableLateDecorrelate;
        private final boolean enableTrim;
        private final boolean enableExpand;
        private final SqlConformance conformance;
        private final Function<RelDataTypeFactory, Prepare.CatalogReader> catalogReaderFactory;
        private final Function<RelOptCluster, RelOptCluster> clusterFactory;
        private RelDataTypeFactory typeFactory;
        public final SqlToRelConverter.Config config;
        private final Context context;

        protected TesterImpl(DiffRepository diffRepos, boolean enableDecorrelate, boolean enableTrim, boolean enableExpand, boolean enableLateDecorrelate, Function<RelDataTypeFactory, Prepare.CatalogReader> catalogReaderFactory, Function<RelOptCluster, RelOptCluster> clusterFactory) {
            this(diffRepos, enableDecorrelate, enableTrim, enableExpand, enableLateDecorrelate, catalogReaderFactory, clusterFactory, SqlToRelConverter.Config.DEFAULT, (SqlConformance)SqlConformanceEnum.DEFAULT, Contexts.empty());
        }

        protected TesterImpl(DiffRepository diffRepos, boolean enableDecorrelate, boolean enableTrim, boolean enableExpand, boolean enableLateDecorrelate, Function<RelDataTypeFactory, Prepare.CatalogReader> catalogReaderFactory, Function<RelOptCluster, RelOptCluster> clusterFactory, SqlToRelConverter.Config config, SqlConformance conformance, Context context) {
            this.diffRepos = diffRepos;
            this.enableDecorrelate = enableDecorrelate;
            this.enableTrim = enableTrim;
            this.enableExpand = enableExpand;
            this.enableLateDecorrelate = enableLateDecorrelate;
            this.catalogReaderFactory = catalogReaderFactory;
            this.clusterFactory = clusterFactory;
            this.config = config;
            this.conformance = conformance;
            this.context = context;
        }

        @Override
        public RelRoot convertSqlToRel(String sql) {
            SqlNode sqlQuery;
            Preconditions.checkNotNull((Object)sql);
            try {
                sqlQuery = this.parseQuery(sql);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            RelDataTypeFactory typeFactory = this.getTypeFactory();
            Prepare.CatalogReader catalogReader = this.createCatalogReader(typeFactory);
            SqlValidator validator = this.createValidator((SqlValidatorCatalogReader)catalogReader, typeFactory);
            SqlToRelConverter.Config localConfig = this.config == SqlToRelConverter.Config.DEFAULT ? SqlToRelConverter.configBuilder().withTrimUnusedFields(true).withExpand(this.enableExpand).build() : this.config;
            SqlToRelConverter converter = this.createSqlToRelConverter(validator, catalogReader, typeFactory, localConfig);
            SqlNode validatedQuery = validator.validate(sqlQuery);
            RelRoot root = converter.convertQuery(validatedQuery, false, true);
            assert (root != null);
            if (this.enableDecorrelate || this.enableTrim) {
                root = root.withRel(converter.flattenTypes(root.rel, true));
            }
            if (this.enableDecorrelate) {
                root = root.withRel(converter.decorrelate(sqlQuery, root.rel));
            }
            if (this.enableTrim) {
                root = root.withRel(converter.trimUnusedFields(true, root.rel));
            }
            return root;
        }

        protected SqlToRelConverter createSqlToRelConverter(SqlValidator validator, Prepare.CatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlToRelConverter.Config config) {
            RexBuilder rexBuilder = new RexBuilder(typeFactory);
            RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)this.getPlanner(), (RexBuilder)rexBuilder);
            if (this.clusterFactory != null) {
                cluster = (RelOptCluster)this.clusterFactory.apply((Object)cluster);
            }
            return new SqlToRelConverter(null, validator, catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, config);
        }

        protected final RelDataTypeFactory getTypeFactory() {
            if (this.typeFactory == null) {
                this.typeFactory = this.createTypeFactory();
            }
            return this.typeFactory;
        }

        protected RelDataTypeFactory createTypeFactory() {
            return new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        }

        protected final RelOptPlanner getPlanner() {
            if (this.planner == null) {
                this.planner = this.createPlanner();
            }
            return this.planner;
        }

        @Override
        public SqlNode parseQuery(String sql) throws Exception {
            SqlParser parser = SqlParser.create((String)sql);
            return parser.parseQuery();
        }

        @Override
        public SqlConformance getConformance() {
            return this.conformance;
        }

        @Override
        public SqlValidator createValidator(SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
            return new FarragoTestValidator(this.getOperatorTable(), catalogReader, typeFactory, this.getConformance());
        }

        @Override
        public final SqlOperatorTable getOperatorTable() {
            if (this.opTab == null) {
                this.opTab = this.createOperatorTable();
            }
            return this.opTab;
        }

        protected SqlOperatorTable createOperatorTable() {
            MockSqlOperatorTable opTab = new MockSqlOperatorTable((SqlOperatorTable)SqlStdOperatorTable.instance());
            MockSqlOperatorTable.addRamp(opTab);
            return opTab;
        }

        @Override
        public Prepare.CatalogReader createCatalogReader(RelDataTypeFactory typeFactory) {
            if (this.catalogReaderFactory != null) {
                return (Prepare.CatalogReader)this.catalogReaderFactory.apply((Object)typeFactory);
            }
            return new MockCatalogReader(typeFactory, true).init();
        }

        @Override
        public RelOptPlanner createPlanner() {
            return new MockRelOptPlanner(this.context);
        }

        @Override
        public void assertConvertsTo(String sql, String plan) {
            this.assertConvertsTo(sql, plan, false);
        }

        @Override
        public void assertConvertsTo(String sql, String plan, boolean trim) {
            String sql2 = this.getDiffRepos().expand("sql", sql);
            RelNode rel = this.convertSqlToRel(sql2).project();
            Assert.assertTrue((rel != null ? 1 : 0) != 0);
            SqlToRelTestBase.assertValid(rel);
            if (trim) {
                RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
                RelFieldTrimmer trimmer = this.createFieldTrimmer(relBuilder);
                Assert.assertTrue(((rel = trimmer.trim(rel)) != null ? 1 : 0) != 0);
                SqlToRelTestBase.assertValid(rel);
            }
            String actual = NL + RelOptUtil.toString((RelNode)rel);
            this.diffRepos.assertEquals("plan", plan, actual);
        }

        public RelFieldTrimmer createFieldTrimmer(RelBuilder relBuilder) {
            return new RelFieldTrimmer(this.getValidator(), relBuilder);
        }

        @Override
        public DiffRepository getDiffRepos() {
            return this.diffRepos;
        }

        @Override
        public SqlValidator getValidator() {
            RelDataTypeFactory typeFactory = this.getTypeFactory();
            Prepare.CatalogReader catalogReader = this.createCatalogReader(typeFactory);
            return this.createValidator((SqlValidatorCatalogReader)catalogReader, typeFactory);
        }

        @Override
        public TesterImpl withDecorrelation(boolean enableDecorrelate) {
            return this.enableDecorrelate == enableDecorrelate ? this : new TesterImpl(this.diffRepos, enableDecorrelate, this.enableTrim, this.enableExpand, this.enableLateDecorrelate, this.catalogReaderFactory, this.clusterFactory, this.config, this.conformance, this.context);
        }

        @Override
        public Tester withLateDecorrelation(boolean enableLateDecorrelate) {
            return this.enableLateDecorrelate == enableLateDecorrelate ? this : new TesterImpl(this.diffRepos, this.enableDecorrelate, this.enableTrim, this.enableExpand, enableLateDecorrelate, this.catalogReaderFactory, this.clusterFactory, this.config, this.conformance, this.context);
        }

        @Override
        public TesterImpl withConfig(SqlToRelConverter.Config config) {
            return this.config == config ? this : new TesterImpl(this.diffRepos, this.enableDecorrelate, this.enableTrim, this.enableExpand, this.enableLateDecorrelate, this.catalogReaderFactory, this.clusterFactory, config, this.conformance, this.context);
        }

        @Override
        public Tester withTrim(boolean enableTrim) {
            return this.enableTrim == enableTrim ? this : new TesterImpl(this.diffRepos, this.enableDecorrelate, enableTrim, this.enableExpand, this.enableLateDecorrelate, this.catalogReaderFactory, this.clusterFactory, this.config, this.conformance, this.context);
        }

        @Override
        public Tester withExpand(boolean enableExpand) {
            return this.enableExpand == enableExpand ? this : new TesterImpl(this.diffRepos, this.enableDecorrelate, this.enableTrim, enableExpand, this.enableLateDecorrelate, this.catalogReaderFactory, this.clusterFactory, this.config, this.conformance, this.context);
        }

        @Override
        public Tester withConformance(SqlConformance conformance) {
            return new TesterImpl(this.diffRepos, this.enableDecorrelate, false, this.enableExpand, this.enableLateDecorrelate, this.catalogReaderFactory, this.clusterFactory, this.config, conformance, this.context);
        }

        @Override
        public Tester withCatalogReaderFactory(Function<RelDataTypeFactory, Prepare.CatalogReader> factory) {
            return new TesterImpl(this.diffRepos, this.enableDecorrelate, false, this.enableExpand, this.enableLateDecorrelate, factory, this.clusterFactory, this.config, this.conformance, this.context);
        }

        @Override
        public Tester withClusterFactory(Function<RelOptCluster, RelOptCluster> clusterFactory) {
            return new TesterImpl(this.diffRepos, this.enableDecorrelate, false, this.enableExpand, this.enableLateDecorrelate, this.catalogReaderFactory, clusterFactory, this.config, this.conformance, this.context);
        }

        @Override
        public Tester withContext(Context context) {
            return new TesterImpl(this.diffRepos, this.enableDecorrelate, false, this.enableExpand, this.enableLateDecorrelate, this.catalogReaderFactory, this.clusterFactory, this.config, this.conformance, context);
        }

        @Override
        public boolean isLateDecorrelate() {
            return this.enableLateDecorrelate;
        }
    }

    private static class DelegatingRelOptTable
    implements RelOptTable {
        private final RelOptTable parent;

        DelegatingRelOptTable(RelOptTable parent) {
            this.parent = parent;
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            return (T)this.parent.unwrap(clazz);
        }

        public Expression getExpression(Class clazz) {
            return this.parent.getExpression(clazz);
        }

        public RelOptTable extend(List<RelDataTypeField> extendedFields) {
            return this.parent.extend(extendedFields);
        }

        public List<String> getQualifiedName() {
            return this.parent.getQualifiedName();
        }

        public double getRowCount() {
            return this.parent.getRowCount();
        }

        public RelDataType getRowType() {
            return this.parent.getRowType();
        }

        public RelOptSchema getRelOptSchema() {
            return this.parent.getRelOptSchema();
        }

        public RelNode toRel(RelOptTable.ToRelContext context) {
            return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)this);
        }

        public List<RelCollation> getCollationList() {
            return this.parent.getCollationList();
        }

        public RelDistribution getDistribution() {
            return this.parent.getDistribution();
        }

        public boolean isKey(ImmutableBitSet columns) {
            return this.parent.isKey(columns);
        }

        public List<RelReferentialConstraint> getReferentialConstraints() {
            return this.parent.getReferentialConstraints();
        }

        public List<ColumnStrategy> getColumnStrategies() {
            return this.parent.getColumnStrategies();
        }
    }

    protected static class MockRelOptSchema
    implements RelOptSchemaWithSampling {
        private final SqlValidatorCatalogReader catalogReader;
        private final RelDataTypeFactory typeFactory;

        public MockRelOptSchema(SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
            this.catalogReader = catalogReader;
            this.typeFactory = typeFactory;
        }

        public RelOptTable getTableForMember(List<String> names) {
            SqlValidatorTable table = this.catalogReader.getTable(names);
            RelDataType rowType = table.getRowType();
            List<RelCollation> collationList = this.deduceMonotonicity(table);
            if (names.size() < 3) {
                String[] newNames2 = new String[]{"CATALOG", "SALES", ""};
                ArrayList<String> newNames = new ArrayList<String>();
                int i = 0;
                while (newNames.size() < newNames2.length) {
                    newNames.add(i, newNames2[i]);
                    ++i;
                }
                names = newNames;
            }
            return this.createColumnSet(table, names, rowType, collationList);
        }

        private List<RelCollation> deduceMonotonicity(SqlValidatorTable table) {
            RelDataType rowType = table.getRowType();
            ArrayList<RelCollation> collationList = new ArrayList<RelCollation>();
            int i = -1;
            for (RelDataTypeField field : rowType.getFieldList()) {
                ++i;
                SqlMonotonicity monotonicity = table.getMonotonicity(field.getName());
                if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
                RelFieldCollation.Direction direction = monotonicity.isDecreasing() ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
                collationList.add(RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(i, direction)}));
            }
            return collationList;
        }

        public RelOptTable getTableForMember(List<String> names, final String datasetName, boolean[] usedDataset) {
            RelOptTable table = this.getTableForMember(names);
            DelegatingRelOptTable datasetTable = new DelegatingRelOptTable(table){

                @Override
                public List<String> getQualifiedName() {
                    ArrayList<String> list = new ArrayList<String>(super.getQualifiedName());
                    list.set(list.size() - 1, (String)list.get(list.size() - 1) + ":" + datasetName);
                    return ImmutableList.copyOf(list);
                }
            };
            if (usedDataset != null) {
                assert (usedDataset.length == 1);
                usedDataset[0] = true;
            }
            return datasetTable;
        }

        protected MockColumnSet createColumnSet(SqlValidatorTable table, List<String> names, RelDataType rowType, List<RelCollation> collationList) {
            return new MockColumnSet(names, rowType, collationList);
        }

        public RelDataTypeFactory getTypeFactory() {
            return this.typeFactory;
        }

        public void registerRules(RelOptPlanner planner) throws Exception {
        }

        protected class MockColumnSet
        implements RelOptTable {
            private final List<String> names;
            private final RelDataType rowType;
            private final List<RelCollation> collationList;

            protected MockColumnSet(List<String> names, RelDataType rowType, List<RelCollation> collationList) {
                this.names = ImmutableList.copyOf(names);
                this.rowType = rowType;
                this.collationList = collationList;
            }

            public <T> T unwrap(Class<T> clazz) {
                if (clazz.isInstance(this)) {
                    return clazz.cast(this);
                }
                return null;
            }

            public List<String> getQualifiedName() {
                return this.names;
            }

            public double getRowCount() {
                if (((String)Iterables.getLast(this.names)).equals("EMP")) {
                    return 1000.0;
                }
                return 100.0;
            }

            public RelDataType getRowType() {
                return this.rowType;
            }

            public RelOptSchema getRelOptSchema() {
                return MockRelOptSchema.this;
            }

            public RelNode toRel(RelOptTable.ToRelContext context) {
                return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)this);
            }

            public List<RelCollation> getCollationList() {
                return this.collationList;
            }

            public RelDistribution getDistribution() {
                return RelDistributions.BROADCAST_DISTRIBUTED;
            }

            public boolean isKey(ImmutableBitSet columns) {
                return false;
            }

            public List<RelReferentialConstraint> getReferentialConstraints() {
                return ImmutableList.of();
            }

            public List<ColumnStrategy> getColumnStrategies() {
                throw new UnsupportedOperationException();
            }

            public Expression getExpression(Class clazz) {
                return null;
            }

            public RelOptTable extend(List<RelDataTypeField> extendedFields) {
                RelDataType extendedRowType = this.getRelOptSchema().getTypeFactory().builder().addAll((Iterable)this.rowType.getFieldList()).addAll(extendedFields).build();
                return new MockColumnSet(this.names, extendedRowType, this.collationList);
            }
        }
    }

    public static interface Tester {
        public RelRoot convertSqlToRel(String var1);

        public SqlNode parseQuery(String var1) throws Exception;

        public SqlValidator createValidator(SqlValidatorCatalogReader var1, RelDataTypeFactory var2);

        public Prepare.CatalogReader createCatalogReader(RelDataTypeFactory var1);

        public RelOptPlanner createPlanner();

        public SqlOperatorTable getOperatorTable();

        public SqlConformance getConformance();

        public void assertConvertsTo(String var1, String var2);

        public void assertConvertsTo(String var1, String var2, boolean var3);

        public DiffRepository getDiffRepos();

        public SqlValidator getValidator();

        public Tester withDecorrelation(boolean var1);

        public Tester withLateDecorrelation(boolean var1);

        public Tester withExpand(boolean var1);

        public Tester withConfig(SqlToRelConverter.Config var1);

        public Tester withConformance(SqlConformance var1);

        public Tester withCatalogReaderFactory(Function<RelDataTypeFactory, Prepare.CatalogReader> var1);

        public Tester withTrim(boolean var1);

        public Tester withClusterFactory(Function<RelOptCluster, RelOptCluster> var1);

        public boolean isLateDecorrelate();

        public Tester withContext(Context var1);
    }
}

