/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import net.hydromatic.quidem.Quidem;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.io.PatternFilenameFilter;
import org.apache.hive.druid.org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.hive.druid.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.prepare.Prepare;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.runtime.Hook;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.test.ConnectionSpec;
import org.apache.hive.druid.org.apache.calcite.test.DiffTestCase;
import org.apache.hive.druid.org.apache.calcite.test.JdbcTest;
import org.apache.hive.druid.org.apache.calcite.test.ReflectiveSchemaTest;
import org.apache.hive.druid.org.apache.calcite.util.Closer;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class QuidemTest {
    protected final String path;
    protected final Method method;

    protected QuidemTest(String path) {
        this.path = path;
        this.method = this.findMethod(path);
    }

    private Method findMethod(String path) {
        Method m;
        String methodName = AvaticaUtils.toCamelCase((String)("test_" + path.replace('/', '_').replaceAll("\\.iq$", "")));
        try {
            m = this.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        return m;
    }

    protected static Collection<Object[]> data(String first) {
        URL inUrl = JdbcTest.class.getResource("/" + first);
        String x = inUrl.getFile();
        assert (x.endsWith(first));
        String base = File.separatorChar == '\\' ? x.substring(1, x.length() - first.length()).replace('/', File.separatorChar) : x.substring(0, x.length() - first.length());
        File firstFile = new File(x);
        File dir = firstFile.getParentFile();
        ArrayList<String> paths = new ArrayList<String>();
        PatternFilenameFilter filter = new PatternFilenameFilter(".*\\.iq$");
        for (File f : (File[])Util.first((Object)dir.listFiles((FilenameFilter)filter), (Object)new File[0])) {
            assert (f.getAbsolutePath().startsWith(base)) : "f: " + f.getAbsolutePath() + "; base: " + base;
            paths.add(f.getAbsolutePath().substring(base.length()));
        }
        return Lists.transform(paths, (Function)new Function<String, Object[]>(){

            public Object[] apply(String path) {
                return new Object[]{path};
            }
        });
    }

    protected void checkRun(String path) throws Exception {
        File outFile;
        File inFile;
        File f = new File(path);
        if (f.isAbsolute()) {
            inFile = f;
            outFile = new File(path + ".out");
        } else {
            URL inUrl = JdbcTest.class.getResource("/" + QuidemTest.n2u(path));
            String x = QuidemTest.u2n(inUrl.getFile());
            assert (x.endsWith(path)) : "x: " + x + "; path: " + path;
            x = x.substring(0, x.length() - path.length());
            assert (x.endsWith(QuidemTest.u2n("/test-classes/")));
            x = x.substring(0, x.length() - QuidemTest.u2n("/test-classes/").length());
            File base = new File(x);
            inFile = new File(base, QuidemTest.u2n("/test-classes/") + path);
            outFile = new File(base, QuidemTest.u2n("/surefire/") + path);
        }
        Util.discard((boolean)outFile.getParentFile().mkdirs());
        try (BufferedReader reader = Util.reader((File)inFile);
             PrintWriter writer = Util.printWriter((File)outFile);
             final Closer closer = new Closer();){
            new Quidem((Reader)reader, (Writer)writer, this.env(), this.createConnectionFactory()).withPropertyHandler(new Quidem.PropertyHandler(){

                public void onSet(String propertyName, Object value) {
                    boolean b;
                    if (propertyName.equals("bindable")) {
                        b = value instanceof Boolean && (Boolean)value != false;
                        closer.add((AutoCloseable)Hook.ENABLE_BINDABLE.addThread(Hook.property((Object)b)));
                    }
                    if (propertyName.equals("expand")) {
                        b = value instanceof Boolean && (Boolean)value != false;
                        closer.add((AutoCloseable)Prepare.THREAD_EXPAND.push((Object)b));
                    }
                }
            }).execute();
        }
        String diff = DiffTestCase.diff(inFile, outFile);
        if (!diff.isEmpty()) {
            Assert.fail((String)("Files differ: " + outFile + " " + inFile + "\n" + diff));
        }
    }

    protected Quidem.ConnectionFactory createConnectionFactory() {
        return new QuidemConnectionFactory();
    }

    private static String u2n(String s) {
        return File.separatorChar == '\\' ? s.replace('/', '\\') : s;
    }

    private static String n2u(String s) {
        return File.separatorChar == '\\' ? s.replace('\\', '/') : s;
    }

    private Function<String, Object> env() {
        return new Function<String, Object>(){

            public Object apply(String varName) {
                switch (varName) {
                    case "jdk18": {
                        return System.getProperty("java.version").startsWith("1.8");
                    }
                    case "fixed": {
                        return new Function<String, Object>(){

                            public Object apply(String v) {
                                switch (v) {
                                    case "calcite1045": {
                                        return false;
                                    }
                                    case "calcite1048": {
                                        return false;
                                    }
                                }
                                return null;
                            }
                        };
                    }
                }
                return null;
            }
        };
    }

    @Test
    public void test() throws Exception {
        if (this.method != null) {
            this.method.invoke((Object)this, new Object[0]);
        } else {
            this.checkRun(this.path);
        }
    }

    protected static class QuidemConnectionFactory
    implements Quidem.ConnectionFactory {
        protected QuidemConnectionFactory() {
        }

        public Connection connect(String name) throws Exception {
            return this.connect(name, false);
        }

        public Connection connect(String name, boolean reference) throws Exception {
            if (reference) {
                if (name.equals("foodmart")) {
                    ConnectionSpec db = CalciteAssert.DatabaseInstance.HSQLDB.foodmart;
                    Connection connection = DriverManager.getConnection(db.url, db.username, db.password);
                    connection.setSchema("foodmart");
                    return connection;
                }
                return null;
            }
            switch (name) {
                case "hr": {
                    return CalciteAssert.hr().connect();
                }
                case "foodmart": {
                    return CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).connect();
                }
                case "geo": {
                    return CalciteAssert.that().with(CalciteAssert.Config.GEO).connect();
                }
                case "scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.SCOTT).connect();
                }
                case "jdbc_scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.JDBC_SCOTT).connect();
                }
                case "post": {
                    return CalciteAssert.that().with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).withDefaultSchema("POST").connect();
                }
                case "catchall": {
                    return CalciteAssert.that().withSchema("s", (Schema)new ReflectiveSchema((Object)new ReflectiveSchemaTest.CatchallSchema())).connect();
                }
                case "orinoco": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.ORINOCO).withDefaultSchema("ORINOCO").connect();
                }
                case "blank": {
                    return CalciteAssert.that().with("parserFactory", "org.apache.hive.druid.org.apache.calcite.sql.parser.parserextensiontesting.ExtensionSqlParserImpl#FACTORY").with(CalciteAssert.SchemaSpec.BLANK).withDefaultSchema("BLANK").connect();
                }
                case "seq": {
                    Connection connection = CalciteAssert.that().withSchema("s", (Schema)new AbstractSchema()).connect();
                    connection.unwrap(CalciteConnection.class).getRootSchema().getSubSchema("s").add("my_seq", (Table)new AbstractTable(){

                        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                            return typeFactory.builder().add("$seq", SqlTypeName.BIGINT).build();
                        }

                        public Schema.TableType getJdbcTableType() {
                            return Schema.TableType.SEQUENCE;
                        }
                    });
                    return connection;
                }
            }
            throw new RuntimeException("unknown connection '" + name + "'");
        }
    }
}

