/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.io.IOException;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.calcite.model.JsonColumn;
import org.apache.hive.druid.org.apache.calcite.model.JsonCustomSchema;
import org.apache.hive.druid.org.apache.calcite.model.JsonCustomTable;
import org.apache.hive.druid.org.apache.calcite.model.JsonJdbcSchema;
import org.apache.hive.druid.org.apache.calcite.model.JsonLattice;
import org.apache.hive.druid.org.apache.calcite.model.JsonMapSchema;
import org.apache.hive.druid.org.apache.calcite.model.JsonRoot;
import org.apache.hive.druid.org.apache.calcite.model.JsonTable;
import org.apache.hive.druid.org.apache.calcite.model.JsonView;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.test.JdbcTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ModelTest {
    private ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return mapper;
    }

    @Test
    public void testRead() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'FoodMart',\n       tables: [\n         {\n           name: 'time_by_day',\n           columns: [\n             {\n               name: 'time_id'\n             }\n           ]\n         },\n         {\n           name: 'sales_fact_1997',\n           columns: [\n             {\n               name: 'time_id'\n             }\n           ]\n         }\n       ]\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((Object)"1.0", (Object)root.version);
        Assert.assertEquals((long)1L, (long)root.schemas.size());
        JsonMapSchema schema = (JsonMapSchema)root.schemas.get(0);
        Assert.assertEquals((Object)"FoodMart", (Object)schema.name);
        Assert.assertEquals((long)2L, (long)schema.tables.size());
        JsonTable table0 = (JsonTable)schema.tables.get(0);
        Assert.assertEquals((Object)"time_by_day", (Object)table0.name);
        JsonTable table1 = (JsonTable)schema.tables.get(1);
        Assert.assertEquals((Object)"sales_fact_1997", (Object)table1.name);
        Assert.assertEquals((long)1L, (long)table0.columns.size());
        JsonColumn column = (JsonColumn)table0.columns.get(0);
        Assert.assertEquals((Object)"time_id", (Object)column.name);
    }

    @Test
    public void testSubtype() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       type: 'jdbc',\n       name: 'FoodMart',\n       jdbcUser: 'u_baz',\n       jdbcPassword: 'p_baz',\n       jdbcUrl: 'jdbc:baz',\n       jdbcCatalog: 'cat_baz',\n       jdbcSchema: ''\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((Object)"1.0", (Object)root.version);
        Assert.assertEquals((long)1L, (long)root.schemas.size());
        JsonJdbcSchema schema = (JsonJdbcSchema)root.schemas.get(0);
        Assert.assertEquals((Object)"FoodMart", (Object)schema.name);
    }

    @Test
    public void testCustomSchema() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       type: 'custom',\n       name: 'My Custom Schema',\n       factory: 'com.acme.MySchemaFactory',\n       operand: {a: 'foo', b: [1, 3.5] },\n       tables: [\n         { type: 'custom', name: 'T1' },\n         { type: 'custom', name: 'T2', operand: {} },\n         { type: 'custom', name: 'T3', operand: {a: 'foo'} }\n       ]\n     },\n     {\n       type: 'custom',\n       name: 'has-no-operand'\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((Object)"1.0", (Object)root.version);
        Assert.assertEquals((long)2L, (long)root.schemas.size());
        JsonCustomSchema schema = (JsonCustomSchema)root.schemas.get(0);
        Assert.assertEquals((Object)"My Custom Schema", (Object)schema.name);
        Assert.assertEquals((Object)"com.acme.MySchemaFactory", (Object)schema.factory);
        Assert.assertEquals((Object)"foo", schema.operand.get("a"));
        Assert.assertNull(schema.operand.get("c"));
        Assert.assertTrue((boolean)(schema.operand.get("b") instanceof List));
        List list = (List)schema.operand.get("b");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)1, list.get(0));
        Assert.assertEquals((Object)3.5, list.get(1));
        Assert.assertEquals((long)3L, (long)schema.tables.size());
        Assert.assertNull((Object)((JsonCustomTable)schema.tables.get((int)0)).operand);
        Assert.assertTrue((boolean)((JsonCustomTable)schema.tables.get((int)1)).operand.isEmpty());
    }

    @Test
    public void testModelImmutableSchemaCannotContainMaterialization() throws Exception {
        CalciteAssert.model("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [\n    {\n      name: 'empty'\n    },\n    {\n      name: 'adhoc',\n      type: 'custom',\n      factory: '" + JdbcTest.MySchemaFactory.class.getName() + "',\n      operand: {\n           'tableName': 'ELVIS',\n           'mutable': false\n      },\n      materializations: [\n        {\n          table: 'v',\n          sql: 'values (1)'\n        }\n      ]\n    }\n  ]\n}").connectThrows("Cannot define materialization; parent schema 'adhoc' is not a SemiMutableSchema");
    }

    @Test
    public void testSchemaWithoutName() throws Exception {
        String model = "{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [ {\n  } ]\n}";
        CalciteAssert.model("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [ {\n  } ]\n}").connectThrows("Field 'name' is required in JsonMapSchema");
    }

    @Test
    public void testCustomSchemaWithoutFactory() throws Exception {
        String model = "{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [ {\n    type: 'custom',\n    name: 'my_custom_schema'\n  } ]\n}";
        CalciteAssert.model("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [ {\n    type: 'custom',\n    name: 'my_custom_schema'\n  } ]\n}").connectThrows("Field 'factory' is required in JsonCustomSchema");
    }

    @Test
    public void testReadLattice() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'FoodMart',\n       tables: [\n         {\n           name: 'time_by_day',\n           columns: [\n             {\n               name: 'time_id'\n             }\n           ]\n         },\n         {\n           name: 'sales_fact_1997',\n           columns: [\n             {\n               name: 'time_id'\n             }\n           ]\n         },\n         {\n           name: 'V',\n           type: 'view',\n           sql: 'values (1)'\n         },\n         {\n           name: 'V2',\n           type: 'view',\n           sql: [ 'values (1)', '(2)' ]\n         }\n       ],\n       lattices: [\n         {\n           name: 'SalesStar',\n           sql: 'select * from sales_fact_1997'\n         },\n         {\n           name: 'SalesStar2',\n           sql: [ 'select *', 'from sales_fact_1997' ]\n         }\n       ]\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((Object)"1.0", (Object)root.version);
        Assert.assertEquals((long)1L, (long)root.schemas.size());
        JsonMapSchema schema = (JsonMapSchema)root.schemas.get(0);
        Assert.assertEquals((Object)"FoodMart", (Object)schema.name);
        Assert.assertEquals((long)2L, (long)schema.lattices.size());
        JsonLattice lattice0 = (JsonLattice)schema.lattices.get(0);
        Assert.assertEquals((Object)"SalesStar", (Object)lattice0.name);
        Assert.assertEquals((Object)"select * from sales_fact_1997", (Object)lattice0.getSql());
        JsonLattice lattice1 = (JsonLattice)schema.lattices.get(1);
        Assert.assertEquals((Object)"SalesStar2", (Object)lattice1.name);
        Assert.assertEquals((Object)"select *\nfrom sales_fact_1997\n", (Object)lattice1.getSql());
        Assert.assertEquals((long)4L, (long)schema.tables.size());
        JsonTable table1 = (JsonTable)schema.tables.get(1);
        Assert.assertTrue((!(table1 instanceof JsonView) ? 1 : 0) != 0);
        JsonTable table2 = (JsonTable)schema.tables.get(2);
        Assert.assertTrue((boolean)(table2 instanceof JsonView));
        Assert.assertThat((Object)((JsonView)table2).getSql(), (Matcher)CoreMatchers.equalTo((Object)"values (1)"));
        JsonTable table3 = (JsonTable)schema.tables.get(3);
        Assert.assertTrue((boolean)(table3 instanceof JsonView));
        Assert.assertThat((Object)((JsonView)table3).getSql(), (Matcher)CoreMatchers.equalTo((Object)"values (1)\n(2)\n"));
    }

    @Test
    public void testReadBadMultiLineSql() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'FoodMart',\n       tables: [\n         {\n           name: 'V',\n           type: 'view',\n           sql: [ 'values (1)', 2 ]\n         }\n       ]\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((long)1L, (long)root.schemas.size());
        JsonMapSchema schema = (JsonMapSchema)root.schemas.get(0);
        Assert.assertEquals((long)1L, (long)schema.tables.size());
        JsonView table1 = (JsonView)schema.tables.get(0);
        try {
            String s = table1.getSql();
            Assert.fail((String)("exprcted error, got " + s));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"each element of a string list must be a string; found: 2"));
        }
    }
}

