/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.type;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class SqlTypeFactoryTest {
    @Test
    public void testLeastRestrictiveWithAny() {
        Fixture f = new Fixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlBigInt, f.sqlAny}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.ANY));
    }

    @Test
    public void testLeastRestrictiveWithNumbers() {
        Fixture f = new Fixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlBigInt, f.sqlInt}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.BIGINT));
    }

    @Test
    public void testLeastRestrictiveWithNullability() {
        Fixture f = new Fixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlVarcharNullable, f.sqlAny}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.ANY));
        Assert.assertThat((Object)leastRestrictive.isNullable(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testLeastRestrictiveWithNull() {
        Fixture f = new Fixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlNull, f.sqlNull}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.NULL));
        Assert.assertThat((Object)leastRestrictive.isNullable(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMaxPrecision() {
        int un = -1;
        this.checkPrecision(1, 1, 1, 0);
        this.checkPrecision(2, 1, 2, 1);
        this.checkPrecision(2, 100, 100, -1);
        this.checkPrecision(2, -1, -1, -1);
        this.checkPrecision(-1, 2, -1, 1);
        this.checkPrecision(-1, -1, -1, 0);
    }

    @Test
    public void testArrayPrecedenceList() {
        Fixture f = new Fixture();
        Assert.assertThat((Object)this.checkPrecendenceList(f.arrayBigInt, f.arrayBigInt, f.arrayFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.arrayOfArrayBigInt, f.arrayOfArrayBigInt, f.arrayOfArrayFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.sqlBigInt, f.sqlBigInt, f.sqlFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.multisetBigInt, f.multisetBigInt, f.multisetFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.arrayBigInt, f.arrayBigInt, f.arrayBigIntNullable), (Matcher)Is.is((Object)0));
        try {
            int i = this.checkPrecendenceList(f.arrayBigInt, f.sqlBigInt, f.sqlInt);
            Assert.fail((String)("Expected assert, got " + i));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"must contain type: BIGINT"));
        }
    }

    private int checkPrecendenceList(RelDataType t, RelDataType type1, RelDataType type2) {
        return t.getPrecedenceList().compareTypePrecedence(type1, type2);
    }

    private void checkPrecision(int p0, int p1, int expectedMax, int expectedComparison) {
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p0, (int)p1), (Matcher)Is.is((Object)expectedMax));
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p1, (int)p0), (Matcher)Is.is((Object)expectedMax));
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p0, (int)p0), (Matcher)Is.is((Object)p0));
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p1, (int)p1), (Matcher)Is.is((Object)p1));
        Assert.assertThat((Object)SqlTypeUtil.comparePrecision((int)p0, (int)p1), (Matcher)Is.is((Object)expectedComparison));
        Assert.assertThat((Object)SqlTypeUtil.comparePrecision((int)p0, (int)p0), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)SqlTypeUtil.comparePrecision((int)p1, (int)p1), (Matcher)Is.is((Object)0));
    }

    private static class Fixture {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        final RelDataType sqlBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BIGINT), false);
        final RelDataType sqlBigIntNullable = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BIGINT), true);
        final RelDataType sqlInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.INTEGER), false);
        final RelDataType sqlVarcharNullable = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
        final RelDataType sqlNull = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.NULL), false);
        final RelDataType sqlAny = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.ANY), false);
        final RelDataType sqlFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.FLOAT), false);
        final RelDataType arrayFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.sqlFloat, -1L), false);
        final RelDataType arrayBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.sqlBigIntNullable, -1L), false);
        final RelDataType multisetFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createMultisetType(this.sqlFloat, -1L), false);
        final RelDataType multisetBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createMultisetType(this.sqlBigIntNullable, -1L), false);
        final RelDataType arrayBigIntNullable = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.sqlBigIntNullable, -1L), true);
        final RelDataType arrayOfArrayBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.arrayBigInt, -1L), false);
        final RelDataType arrayOfArrayFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.arrayFloat, -1L), false);

        private Fixture() {
        }
    }
}

