/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.test;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hive.druid.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.test.SqlTester;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class SqlTests {
    public static final SqlTester.TypeChecker INTEGER_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.INTEGER);
    public static final SqlTester.TypeChecker BOOLEAN_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.BOOLEAN);
    public static final SqlTester.TypeChecker ANY_TYPE_CHECKER = new SqlTester.TypeChecker(){

        @Override
        public void checkType(RelDataType type) {
        }
    };
    public static final SqlTester.ParameterChecker ANY_PARAMETER_CHECKER = new SqlTester.ParameterChecker(){

        @Override
        public void checkParameters(RelDataType parameterRowType) {
        }
    };
    public static final SqlTester.ResultChecker ANY_RESULT_CHECKER = new SqlTester.ResultChecker(){

        @Override
        public void checkResult(ResultSet result) {
        }
    };

    public static String getTypeString(RelDataType sqlType) {
        switch (sqlType.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                String actual = sqlType.getSqlTypeName().name();
                if (sqlType.getPrecision() != -1) {
                    actual = actual + "(" + sqlType.getPrecision() + ")";
                }
                if (!sqlType.isNullable()) {
                    actual = actual + " NOT NULL";
                }
                return actual;
            }
        }
        String s = sqlType.getFullTypeString();
        return s.replace(" CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"", "");
    }

    public static String generateAggQuery(String expr, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" FROM ");
        if (inputValues.length == 0) {
            buf.append("(VALUES 1) AS t(x) WHERE false");
        } else {
            buf.append("(");
            for (int i = 0; i < inputValues.length; ++i) {
                if (i > 0) {
                    buf.append(" UNION ALL ");
                }
                buf.append("SELECT ");
                String inputValue = inputValues[i];
                buf.append(inputValue).append(" AS x FROM (VALUES (1))");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String generateWinAggQuery(String expr, String windowSpec, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" OVER (").append(windowSpec).append(") FROM (");
        for (int i = 0; i < inputValues.length; ++i) {
            if (i > 0) {
                buf.append(" UNION ALL ");
            }
            buf.append("SELECT ");
            String inputValue = inputValues[i];
            buf.append(inputValue).append(" AS x FROM (VALUES (1))");
        }
        buf.append(")");
        return buf.toString();
    }

    public static void compareResultSet(ResultSet resultSet, Set<String> refSet) throws Exception {
        HashSet<String> actualSet = new HashSet<String>();
        int columnType = resultSet.getMetaData().getColumnType(1);
        ColumnMetaData.Rep rep = SqlTests.rep(columnType);
        while (resultSet.next()) {
            String s = resultSet.getString(1);
            String s0 = s == null ? "0" : s;
            boolean wasNull0 = resultSet.wasNull();
            actualSet.add(s);
            switch (rep) {
                case BOOLEAN: {
                    Assert.assertThat((Object)resultSet.getBoolean(1), (Matcher)CoreMatchers.equalTo((Object)Boolean.valueOf(s)));
                    break;
                }
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    long l;
                    try {
                        l = Long.parseLong(s0);
                    }
                    catch (NumberFormatException e) {
                        l = (long)Double.parseDouble(s0);
                    }
                    Assert.assertThat((Object)resultSet.getByte(1), (Matcher)CoreMatchers.equalTo((Object)((byte)l)));
                    Assert.assertThat((Object)resultSet.getShort(1), (Matcher)CoreMatchers.equalTo((Object)((short)l)));
                    Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)((int)l)));
                    Assert.assertThat((Object)resultSet.getLong(1), (Matcher)CoreMatchers.equalTo((Object)l));
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    double d = Double.parseDouble(s0);
                    Assert.assertThat((Object)Float.valueOf(resultSet.getFloat(1)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf((float)d)));
                    Assert.assertThat((Object)resultSet.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)d));
                }
            }
            boolean wasNull1 = resultSet.wasNull();
            Object object = resultSet.getObject(1);
            boolean wasNull2 = resultSet.wasNull();
            Assert.assertThat((Object)(object == null ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)wasNull0));
            Assert.assertThat((Object)wasNull1, (Matcher)CoreMatchers.equalTo((Object)wasNull0));
            Assert.assertThat((Object)wasNull2, (Matcher)CoreMatchers.equalTo((Object)wasNull0));
        }
        resultSet.close();
        Assert.assertEquals(refSet, actualSet);
    }

    private static ColumnMetaData.Rep rep(int columnType) {
        switch (columnType) {
            case 16: {
                return ColumnMetaData.Rep.BOOLEAN;
            }
            case -6: {
                return ColumnMetaData.Rep.BYTE;
            }
            case 5: {
                return ColumnMetaData.Rep.SHORT;
            }
            case 4: {
                return ColumnMetaData.Rep.INTEGER;
            }
            case -5: {
                return ColumnMetaData.Rep.LONG;
            }
            case 7: {
                return ColumnMetaData.Rep.FLOAT;
            }
            case 8: {
                return ColumnMetaData.Rep.DOUBLE;
            }
            case 92: {
                return ColumnMetaData.Rep.JAVA_SQL_TIME;
            }
            case 93: {
                return ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP;
            }
            case 91: {
                return ColumnMetaData.Rep.JAVA_SQL_DATE;
            }
        }
        return ColumnMetaData.Rep.OBJECT;
    }

    public static void compareResultSetWithPattern(ResultSet resultSet, Pattern pattern) throws Exception {
        if (!resultSet.next()) {
            Assert.fail((String)"Query returned 0 rows, expected 1");
        }
        String actual = resultSet.getString(1);
        if (resultSet.next()) {
            Assert.fail((String)"Query returned 2 or more rows, expected 1");
        }
        if (!pattern.matcher(actual).matches()) {
            Assert.fail((String)("Query returned '" + actual + "', expected '" + pattern.pattern() + "'"));
        }
    }

    public static void compareResultSetWithDelta(ResultSet resultSet, double expected, double delta) throws Exception {
        if (!resultSet.next()) {
            Assert.fail((String)"Query returned 0 rows, expected 1");
        }
        double actual = resultSet.getDouble(1);
        if (resultSet.next()) {
            Assert.fail((String)"Query returned 2 or more rows, expected 1");
        }
        if (actual < expected - delta || actual > expected + delta) {
            Assert.fail((String)("Query returned " + actual + ", expected " + expected + (delta == 0.0 ? "" : "+/-" + delta)));
        }
    }

    public static SqlTester.ResultChecker createChecker(Object result, double delta) {
        if (result instanceof Pattern) {
            return new PatternResultChecker((Pattern)result);
        }
        if (delta != 0.0) {
            Assert.assertTrue((boolean)(result instanceof Number));
            return new ApproximateResultChecker((Number)result, delta);
        }
        HashSet<String> refSet = new HashSet<String>();
        if (result == null) {
            refSet.add(null);
        } else if (result instanceof Collection) {
            Collection collection = (Collection)result;
            refSet.addAll(collection);
        } else {
            refSet.add(result.toString());
        }
        return new RefSetResultChecker(refSet);
    }

    public static class RefSetResultChecker
    implements SqlTester.ResultChecker {
        private final Set<String> expected;

        private RefSetResultChecker(Set<String> expected) {
            this.expected = expected;
        }

        @Override
        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSet(resultSet, this.expected);
        }
    }

    public static class ApproximateResultChecker
    implements SqlTester.ResultChecker {
        private final Number expected;
        private final double delta;

        public ApproximateResultChecker(Number expected, double delta) {
            this.expected = expected;
            this.delta = delta;
        }

        @Override
        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSetWithDelta(resultSet, this.expected.doubleValue(), this.delta);
        }
    }

    public static class PatternResultChecker
    implements SqlTester.ResultChecker {
        private final Pattern pattern;

        public PatternResultChecker(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSetWithPattern(resultSet, this.pattern);
        }
    }

    public static class StringTypeChecker
    implements SqlTester.TypeChecker {
        private final String expected;

        public StringTypeChecker(String expected) {
            this.expected = expected;
        }

        @Override
        public void checkType(RelDataType type) {
            String actual = SqlTests.getTypeString(type);
            Assert.assertEquals((Object)this.expected, (Object)actual);
        }
    }

    private static class SqlTypeChecker
    implements SqlTester.TypeChecker {
        private final SqlTypeName typeName;

        SqlTypeChecker(SqlTypeName typeName) {
            this.typeName = typeName;
        }

        @Override
        public void checkType(RelDataType type) {
            Assert.assertEquals((Object)this.typeName.toString(), (Object)type.toString());
        }
    }
}

