/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.parser.parserextensiontesting;

import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserTest;
import org.apache.hive.druid.org.apache.calcite.sql.parser.parserextensiontesting.ExtensionSqlParserImpl;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Test;

public class ExtensionSqlParserTest
extends SqlParserTest {
    @Override
    protected SqlParserImplFactory parserImplFactory() {
        return ExtensionSqlParserImpl.FACTORY;
    }

    @Test
    public void testAlterSystemExtension() throws SqlParseException {
        this.check("alter system upload jar '/path/to/jar'", "ALTER SYSTEM UPLOAD JAR '/path/to/jar'");
    }

    @Test
    public void testAlterSystemExtensionWithoutAlter() throws SqlParseException {
        this.checkFails("^upload^ jar '/path/to/jar'", "(?s).*Encountered \"upload\" at .*");
    }

    @Test
    public void testCreateTable() {
        this.sql("CREATE TABLE foo.baz(i INTEGER, j VARCHAR(10) NOT NULL)").ok("CREATE TABLE `FOO`.`BAZ` (`I` INTEGER, `J` VARCHAR(10) NOT NULL)");
    }

    @Test
    public void testExtendedSqlStmt() {
        this.sql("DESCRIBE SPACE POWER").node((Matcher<SqlNode>)new IsNull());
        this.sql("DESCRIBE SEA ^POWER^").fails("(?s)Encountered \"POWER\" at line 1, column 14..*");
    }
}

