/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.test.udt.util;

import com.yammer.metrics.core.Meter;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.udt.UdtMessage;
import org.apache.hive.druid.io.netty.channel.udt.nio.NioUdtProvider;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;

public class EchoMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EchoMessageHandler.class);
    private final Meter meter;
    private final UdtMessage message;

    public Meter meter() {
        return this.meter;
    }

    public EchoMessageHandler(Meter meter, int messageSize) {
        this.meter = meter;
        ByteBuf byteBuf = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < byteBuf.capacity(); ++i) {
            byteBuf.writeByte((int)((byte)i));
        }
        this.message = new UdtMessage(byteBuf);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active {}", (Object)NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.writeAndFlush((Object)this.message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        log.error("exception", e);
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        UdtMessage udtMsg = (UdtMessage)msg;
        if (this.meter != null) {
            this.meter.mark((long)udtMsg.content().readableBytes());
        }
        ctx.writeAndFlush(msg);
    }
}

