/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelFutureListener;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.ChannelInitializer;
import org.apache.hive.druid.io.netty.channel.ChannelPipeline;
import org.apache.hive.druid.io.netty.channel.EventLoop;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hive.druid.io.netty.channel.socket.ServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.socket.SocketChannel;
import org.apache.hive.druid.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hive.druid.io.netty.handler.proxy.ProxyHandlerTest;
import org.apache.hive.druid.io.netty.handler.proxy.TestMode;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.apache.hive.druid.io.netty.util.NetUtil;
import org.apache.hive.druid.io.netty.util.ReferenceCountUtil;
import org.apache.hive.druid.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hive.druid.io.netty.util.internal.PlatformDependent;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;

abstract class ProxyServer {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final ServerSocketChannel ch;
    private final Queue<Throwable> recordedExceptions = new LinkedBlockingQueue<Throwable>();
    protected final TestMode testMode;
    protected final String username;
    protected final String password;
    protected final InetSocketAddress destination;

    protected ProxyServer(boolean useSsl, TestMode testMode, InetSocketAddress destination) {
        this(useSsl, testMode, destination, null, null);
    }

    protected ProxyServer(final boolean useSsl, TestMode testMode, InetSocketAddress destination, String username, String password) {
        this.testMode = testMode;
        this.destination = destination;
        this.username = username;
        this.password = password;
        ServerBootstrap b = new ServerBootstrap();
        b.channel(NioServerSocketChannel.class);
        b.group(ProxyHandlerTest.group);
        b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (useSsl) {
                    p.addLast(new ChannelHandler[]{ProxyHandlerTest.serverSslCtx.newHandler(ch.alloc())});
                }
                ProxyServer.this.configure(ch);
            }
        });
        this.ch = (ServerSocketChannel)b.bind(NetUtil.LOCALHOST, 0).syncUninterruptibly().channel();
    }

    public final InetSocketAddress address() {
        return new InetSocketAddress(NetUtil.LOCALHOST, this.ch.localAddress().getPort());
    }

    protected abstract void configure(SocketChannel var1) throws Exception;

    final void recordException(Throwable t) {
        this.logger.warn("Unexpected exception from proxy server:", t);
        this.recordedExceptions.add(t);
    }

    public final void clearExceptions() {
        this.recordedExceptions.clear();
    }

    public final void checkExceptions() {
        Throwable t;
        while ((t = this.recordedExceptions.poll()) != null) {
            this.logger.warn("Unexpected exception:", t);
        }
        if (t != null) {
            PlatformDependent.throwException((Throwable)t);
        }
    }

    public final void stop() {
        this.ch.close();
    }

    protected abstract class TerminalHandler
    extends SimpleChannelInboundHandler<Object> {
        private boolean finished;

        protected TerminalHandler() {
        }

        protected final void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.finished) {
                String str = ((ByteBuf)msg).toString(CharsetUtil.US_ASCII);
                if ("A\n".equals(str)) {
                    ctx.write((Object)Unpooled.copiedBuffer((CharSequence)"1\n", (Charset)CharsetUtil.US_ASCII));
                } else if ("B\n".equals(str)) {
                    ctx.write((Object)Unpooled.copiedBuffer((CharSequence)"2\n", (Charset)CharsetUtil.US_ASCII));
                } else if ("C\n".equals(str)) {
                    ctx.write((Object)Unpooled.copiedBuffer((CharSequence)"3\n", (Charset)CharsetUtil.US_ASCII)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    throw new IllegalStateException("unexpected message: " + str);
                }
                return;
            }
            boolean finished = this.handleProxyProtocol(ctx, msg);
            if (finished) {
                this.finished = finished;
            }
        }

        protected abstract boolean handleProxyProtocol(ChannelHandlerContext var1, Object var2) throws Exception;

        public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ProxyServer.this.recordException(cause);
            ctx.close();
        }
    }

    protected abstract class IntermediaryHandler
    extends SimpleChannelInboundHandler<Object> {
        private final Queue<Object> received = new ArrayDeque<Object>();
        private boolean finished;
        private Channel backend;

        protected IntermediaryHandler() {
        }

        protected final void channelRead0(final ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.finished) {
                this.received.add(ReferenceCountUtil.retain((Object)msg));
                this.flush();
                return;
            }
            boolean finished = this.handleProxyProtocol(ctx, msg);
            if (finished) {
                this.finished = true;
                ChannelFuture f = this.connectToDestination(ctx.channel().eventLoop(), (ChannelHandler)new BackendHandler(ctx));
                f.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            ProxyServer.this.recordException(future.cause());
                            ctx.close();
                        } else {
                            IntermediaryHandler.this.backend = future.channel();
                            IntermediaryHandler.this.flush();
                        }
                    }
                });
            }
        }

        private void flush() {
            if (this.backend != null) {
                Object msg;
                boolean wrote = false;
                while ((msg = this.received.poll()) != null) {
                    this.backend.write(msg);
                    wrote = true;
                }
                if (wrote) {
                    this.backend.flush();
                }
            }
        }

        protected abstract boolean handleProxyProtocol(ChannelHandlerContext var1, Object var2) throws Exception;

        protected abstract SocketAddress intermediaryDestination();

        private ChannelFuture connectToDestination(EventLoop loop, ChannelHandler handler) {
            Bootstrap b = new Bootstrap();
            b.channel(NioSocketChannel.class);
            b.group((EventLoopGroup)loop);
            b.handler(handler);
            return b.connect(this.intermediaryDestination());
        }

        public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.backend != null) {
                this.backend.close();
            }
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ProxyServer.this.recordException(cause);
            ctx.close();
        }

        private final class BackendHandler
        extends ChannelInboundHandlerAdapter {
            private final ChannelHandlerContext frontend;

            BackendHandler(ChannelHandlerContext frontend) {
                this.frontend = frontend;
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                this.frontend.write(msg);
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                this.frontend.flush();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                this.frontend.close();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ProxyServer.this.recordException(cause);
                ctx.close();
            }
        }
    }
}

