/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.stomp;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.stomp.LastStompContentSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompCommand;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompContentSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompHeadersSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompSubframeDecoder;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class StompCommandDecodeTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(true)});
    }

    @AfterEach
    public void tearDown() {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @ParameterizedTest(name="{index}: testDecodeCommand({0}) = {1}")
    @MethodSource(value={"stompCommands"})
    public void testDecodeCommand(String rawCommand, StompCommand expectedCommand, Boolean valid) {
        byte[] frameContent = String.format("%s\n\n\u0000", rawCommand).getBytes(CharsetUtil.UTF_8);
        ByteBuf incoming = Unpooled.wrappedBuffer((byte[])frameContent);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{incoming}));
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((Object)expectedCommand, (Object)frame.command());
        if (valid.booleanValue()) {
            Assertions.assertTrue((boolean)frame.decoderResult().isSuccess());
            StompContentSubframe content = (StompContentSubframe)this.channel.readInbound();
            Assertions.assertSame((Object)LastStompContentSubframe.EMPTY_LAST_CONTENT, (Object)content);
            content.release();
        } else {
            Assertions.assertTrue((boolean)frame.decoderResult().isFailure());
            Assertions.assertNull((Object)this.channel.readInbound());
        }
    }

    public static Collection<Object[]> stompCommands() {
        return Arrays.asList({"STOMP", StompCommand.STOMP, true}, {"CONNECT", StompCommand.CONNECT, true}, {"SEND", StompCommand.SEND, true}, {"SUBSCRIBE", StompCommand.SUBSCRIBE, true}, {"UNSUBSCRIBE", StompCommand.UNSUBSCRIBE, true}, {"ACK", StompCommand.ACK, true}, {"NACK", StompCommand.NACK, true}, {"BEGIN", StompCommand.BEGIN, true}, {"ABORT", StompCommand.ABORT, true}, {"COMMIT", StompCommand.COMMIT, true}, {"DISCONNECT", StompCommand.DISCONNECT, true}, {"INVALID", StompCommand.UNKNOWN, false}, {"disconnect", StompCommand.UNKNOWN, false});
    }
}

