/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.redis;

import java.util.ArrayList;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.redis.ArrayRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.DefaultBulkStringRedisContent;
import org.apache.hive.druid.io.netty.handler.codec.redis.DefaultLastBulkStringRedisContent;
import org.apache.hive.druid.io.netty.handler.codec.redis.ErrorRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.InlineCommandRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.IntegerRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisCodecTestUtil;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisEncoder;
import org.apache.hive.druid.io.netty.handler.codec.redis.SimpleStringRedisMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RedisEncoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new RedisEncoder()});
    }

    @AfterEach
    public void teardown() throws Exception {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void shouldEncodeInlineCommand() {
        InlineCommandRedisMessage msg = new InlineCommandRedisMessage("ping");
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Object)RedisCodecTestUtil.bytesOf("ping\r\n")));
        written.release();
    }

    @Test
    public void shouldEncodeSimpleString() {
        SimpleStringRedisMessage msg = new SimpleStringRedisMessage("simple");
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Object)RedisCodecTestUtil.bytesOf("+simple\r\n")));
        written.release();
    }

    @Test
    public void shouldEncodeError() {
        ErrorRedisMessage msg = new ErrorRedisMessage("error1");
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("-error1\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeInteger() {
        IntegerRedisMessage msg = new IntegerRedisMessage(1234L);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf(":1234\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeBulkStringContent() {
        BulkStringHeaderRedisMessage header = new BulkStringHeaderRedisMessage(16);
        DefaultBulkStringRedisContent body1 = new DefaultBulkStringRedisContent(RedisCodecTestUtil.byteBufOf("bulk\nstr").retain());
        DefaultLastBulkStringRedisContent body2 = new DefaultLastBulkStringRedisContent(RedisCodecTestUtil.byteBufOf("ing\ntest").retain());
        MatcherAssert.assertThat((Object)this.channel.writeOutbound(new Object[]{header}), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.channel.writeOutbound(new Object[]{body1}), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.channel.writeOutbound(new Object[]{body2}), (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("$16\r\nbulk\nstring\ntest\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeFullBulkString() {
        ByteBuf bulkString = RedisCodecTestUtil.byteBufOf("bulk\nstring\ntest").retain();
        int length = bulkString.readableBytes();
        FullBulkStringRedisMessage msg = new FullBulkStringRedisMessage(bulkString);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("$" + length + "\r\nbulk\nstring\ntest\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeSimpleArray() {
        ArrayList<FullBulkStringRedisMessage> children = new ArrayList<FullBulkStringRedisMessage>();
        children.add(new FullBulkStringRedisMessage(RedisCodecTestUtil.byteBufOf("foo").retain()));
        children.add(new FullBulkStringRedisMessage(RedisCodecTestUtil.byteBufOf("bar").retain()));
        ArrayRedisMessage msg = new ArrayRedisMessage(children);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*2\r\n$3\r\nfoo\r\n$3\r\nbar\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeNullArray() {
        ArrayRedisMessage msg = ArrayRedisMessage.NULL_INSTANCE;
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*-1\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeEmptyArray() {
        ArrayRedisMessage msg = ArrayRedisMessage.EMPTY_INSTANCE;
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*0\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeNestedArray() {
        ArrayList<Object> grandChildren = new ArrayList<Object>();
        grandChildren.add(new FullBulkStringRedisMessage(RedisCodecTestUtil.byteBufOf("bar")));
        grandChildren.add(new IntegerRedisMessage(-1234L));
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(new SimpleStringRedisMessage("foo"));
        children.add(new ArrayRedisMessage(grandChildren));
        ArrayRedisMessage msg = new ArrayRedisMessage(children);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*2\r\n+foo\r\n*2\r\n$3\r\nbar\r\n:-1234\r\n"))));
        written.release();
    }

    private static ByteBuf readAll(EmbeddedChannel channel) {
        ByteBuf read;
        ByteBuf buf = Unpooled.buffer();
        while ((read = (ByteBuf)channel.readOutbound()) != null) {
            buf.writeBytes(read);
            read.release();
        }
        return buf;
    }
}

