/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufInputStream;
import org.apache.hive.druid.io.netty.buffer.ByteBufOutputStream;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelId;
import org.apache.hive.druid.io.netty.channel.DefaultChannelId;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2StreamChannelId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Http2StreamChannelIdTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialization() throws Exception {
        ChannelId deserializedInstance;
        Http2StreamChannelId normalInstance = new Http2StreamChannelId((ChannelId)DefaultChannelId.newInstance(), 0);
        ByteBuf buf = Unpooled.buffer();
        ObjectOutputStream outStream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            outStream.writeObject(normalInstance);
        }
        finally {
            outStream.close();
        }
        ObjectInputStream inStream = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));
        try {
            deserializedInstance = (ChannelId)inStream.readObject();
        }
        finally {
            inStream.close();
        }
        Assertions.assertEquals((Object)normalInstance, (Object)deserializedInstance);
        Assertions.assertEquals((int)normalInstance.hashCode(), (int)deserializedInstance.hashCode());
        Assertions.assertEquals((int)0, (int)normalInstance.compareTo((Object)deserializedInstance));
        Assertions.assertEquals((Object)normalInstance.asLongText(), (Object)deserializedInstance.asLongText());
        Assertions.assertEquals((Object)normalInstance.asShortText(), (Object)deserializedInstance.asShortText());
    }
}

