/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.io.druid.server.router.CoordinatorRuleManager;
import org.apache.hive.druid.io.druid.server.router.PriorityTieredBrokerSelectorStrategy;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerConfig;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerHostSelector;
import org.apache.hive.druid.io.druid.server.router.TimeBoundaryTieredBrokerSelectorStrategy;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TieredBrokerHostSelectorTest {
    private DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private DruidNodeDiscovery druidNodeDiscovery;
    private TieredBrokerHostSelector brokerSelector;
    private DiscoveryDruidNode node1;
    private DiscoveryDruidNode node2;
    private DiscoveryDruidNode node3;

    @Before
    public void setUp() throws Exception {
        this.druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createStrictMock(DruidNodeDiscoveryProvider.class);
        this.node1 = new DiscoveryDruidNode(new DruidNode("hotBroker", "hotHost", Integer.valueOf(8080), null, true, false), "broker", (Map)ImmutableMap.of());
        this.node2 = new DiscoveryDruidNode(new DruidNode("coldBroker", "coldHost1", Integer.valueOf(8080), null, true, false), "broker", (Map)ImmutableMap.of());
        this.node3 = new DiscoveryDruidNode(new DruidNode("coldBroker", "coldHost2", Integer.valueOf(8080), null, true, false), "broker", (Map)ImmutableMap.of());
        this.druidNodeDiscovery = new DruidNodeDiscovery(){

            public Collection<DiscoveryDruidNode> getAllNodes() {
                return ImmutableSet.of((Object)TieredBrokerHostSelectorTest.this.node1, (Object)TieredBrokerHostSelectorTest.this.node2, (Object)TieredBrokerHostSelectorTest.this.node3);
            }

            public void registerListener(DruidNodeDiscovery.Listener listener) {
                listener.nodesAdded((List)ImmutableList.of((Object)TieredBrokerHostSelectorTest.this.node1, (Object)TieredBrokerHostSelectorTest.this.node2, (Object)TieredBrokerHostSelectorTest.this.node3));
            }
        };
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeType("broker")).andReturn((Object)this.druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{this.druidNodeDiscoveryProvider});
        this.brokerSelector = new TieredBrokerHostSelector((CoordinatorRuleManager)new TestRuleManager(null, null), new TieredBrokerConfig(){

            public LinkedHashMap<String, String> getTierToBrokerMap() {
                return new LinkedHashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"hot", (Object)"hotBroker", (Object)"medium", (Object)"mediumBroker", (Object)"_default_tier", (Object)"coldBroker"));
            }

            public String getDefaultBrokerServiceName() {
                return "hotBroker";
            }
        }, this.druidNodeDiscoveryProvider, Arrays.asList(new TimeBoundaryTieredBrokerSelectorStrategy(), new PriorityTieredBrokerSelectorStrategy(Integer.valueOf(0), Integer.valueOf(1))));
        this.brokerSelector.start();
    }

    @After
    public void tearDown() throws Exception {
        this.brokerSelector.stop();
        EasyMock.verify((Object[])new Object[]{this.druidNodeDiscoveryProvider});
    }

    @Test
    public void testBasicSelect() throws Exception {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity("all").aggregators(Arrays.asList(new CountAggregatorFactory("rows"))).intervals(Arrays.asList(Intervals.of((String)"2011-08-31/2011-09-01"))).build();
        Pair p = this.brokerSelector.select((Query)query);
        Assert.assertEquals((Object)"coldBroker", (Object)p.lhs);
        Assert.assertEquals((Object)"coldHost1:8080", (Object)((Server)p.rhs).getHost());
        p = this.brokerSelector.select((Query)query);
        Assert.assertEquals((Object)"coldBroker", (Object)p.lhs);
        Assert.assertEquals((Object)"coldHost2:8080", (Object)((Server)p.rhs).getHost());
        p = this.brokerSelector.select((Query)query);
        Assert.assertEquals((Object)"coldBroker", (Object)p.lhs);
        Assert.assertEquals((Object)"coldHost1:8080", (Object)((Server)p.rhs).getHost());
    }

    @Test
    public void testBasicSelect2() throws Exception {
        Pair p = this.brokerSelector.select((Query)Druids.newTimeseriesQueryBuilder().dataSource("test").granularity("all").aggregators(Arrays.asList(new CountAggregatorFactory("rows"))).intervals(Arrays.asList(Intervals.of((String)"2013-08-31/2013-09-01"))).build());
        Assert.assertEquals((Object)"hotBroker", (Object)p.lhs);
        Assert.assertEquals((Object)"hotHost:8080", (Object)((Server)p.rhs).getHost());
    }

    @Test
    public void testSelectMatchesNothing() throws Exception {
        String brokerName = (String)this.brokerSelector.select((Query)Druids.newTimeseriesQueryBuilder().dataSource((String)"test").granularity((String)"all").aggregators(Arrays.asList(new AggregatorFactory[]{new CountAggregatorFactory((String)"rows")})).intervals(Arrays.asList(new Interval[]{Intervals.of((String)"2010-08-31/2010-09-01")})).build()).lhs;
        Assert.assertEquals((Object)"hotBroker", (Object)brokerName);
    }

    @Test
    public void testSelectMultiInterval() throws Exception {
        String brokerName = (String)this.brokerSelector.select((Query)Druids.newTimeseriesQueryBuilder().dataSource((String)"test").aggregators(Arrays.asList(new AggregatorFactory[]{new CountAggregatorFactory((String)"count")})).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(new Interval[]{Intervals.of((String)"2013-08-31/2013-09-01"), Intervals.of((String)"2012-08-31/2012-09-01"), Intervals.of((String)"2011-08-31/2011-09-01")}))).build()).lhs;
        Assert.assertEquals((Object)"coldBroker", (Object)brokerName);
    }

    @Test
    public void testSelectMultiInterval2() throws Exception {
        String brokerName = (String)this.brokerSelector.select((Query)Druids.newTimeseriesQueryBuilder().dataSource((String)"test").aggregators(Arrays.asList(new AggregatorFactory[]{new CountAggregatorFactory((String)"count")})).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(new Interval[]{Intervals.of((String)"2011-08-31/2011-09-01"), Intervals.of((String)"2012-08-31/2012-09-01"), Intervals.of((String)"2013-08-31/2013-09-01")}))).build()).lhs;
        Assert.assertEquals((Object)"coldBroker", (Object)brokerName);
    }

    @Test
    public void testPrioritySelect() throws Exception {
        String brokerName = (String)this.brokerSelector.select((Query)Druids.newTimeseriesQueryBuilder().dataSource((String)"test").aggregators(Arrays.asList(new AggregatorFactory[]{new CountAggregatorFactory((String)"count")})).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(new Interval[]{Intervals.of((String)"2011-08-31/2011-09-01"), Intervals.of((String)"2012-08-31/2012-09-01"), Intervals.of((String)"2013-08-31/2013-09-01")}))).context((Map)ImmutableMap.of((Object)"priority", (Object)Integer.valueOf((int)-1))).build()).lhs;
        Assert.assertEquals((Object)"hotBroker", (Object)brokerName);
    }

    @Test
    public void testPrioritySelect2() throws Exception {
        String brokerName = (String)this.brokerSelector.select((Query)Druids.newTimeseriesQueryBuilder().dataSource((String)"test").aggregators(Arrays.asList(new AggregatorFactory[]{new CountAggregatorFactory((String)"count")})).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(new Interval[]{Intervals.of((String)"2011-08-31/2011-09-01"), Intervals.of((String)"2012-08-31/2012-09-01"), Intervals.of((String)"2013-08-31/2013-09-01")}))).context((Map)ImmutableMap.of((Object)"priority", (Object)Integer.valueOf((int)5))).build()).lhs;
        Assert.assertEquals((Object)"hotBroker", (Object)brokerName);
    }

    @Test
    public void testGetAllBrokers() {
        Assert.assertEquals((Object)ImmutableMap.of((Object)"mediumBroker", (Object)ImmutableList.of(), (Object)"coldBroker", (Object)ImmutableList.of((Object)"coldHost1:8080", (Object)"coldHost2:8080"), (Object)"hotBroker", (Object)ImmutableList.of((Object)"hotHost:8080")), (Object)Maps.transformValues((Map)this.brokerSelector.getAllBrokers(), (Function)new Function<List<Server>, List<String>>(){

            public List<String> apply(@Nullable List<Server> servers) {
                return Lists.transform(servers, server -> server.getHost());
            }
        }));
    }

    private static class TestRuleManager
    extends CoordinatorRuleManager {
        public TestRuleManager(@Json ObjectMapper jsonMapper, Supplier<TieredBrokerConfig> config) {
            super(jsonMapper, config, null);
        }

        public boolean isStarted() {
            return true;
        }

        public List<Rule> getRulesWithDefault(String dataSource) {
            return Arrays.asList(new IntervalLoadRule(Intervals.of((String)"2013/2014"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012/2013"), (Map)ImmutableMap.of((Object)"medium", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2011/2012"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)1)));
        }
    }
}

