/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http.security;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.server.http.security.AbstractResourceFilter;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.io.druid.server.security.Authorizer;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.easymock.EasyMock;

public class ResourceFilterTestHelper {
    public HttpServletRequest req;
    public AuthorizerMapper authorizerMapper;
    public ContainerRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(ResourceFilter resourceFilter) throws Exception {
        this.req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        this.request = (ContainerRequest)EasyMock.createStrictMock(ContainerRequest.class);
        this.authorizerMapper = (AuthorizerMapper)EasyMock.createStrictMock(AuthorizerMapper.class);
        ResourceFilterTestHelper resourceFilterTestHelper = this;
        synchronized (resourceFilterTestHelper) {
            ((AbstractResourceFilter)resourceFilter).setReq(this.req);
            ((AbstractResourceFilter)resourceFilter).setAuthorizerMapper(this.authorizerMapper);
        }
    }

    public void setUpMockExpectations(String requestPath, final boolean authCheckResult, String requestMethod) {
        EasyMock.expect((Object)this.request.getPath()).andReturn((Object)requestPath).anyTimes();
        EasyMock.expect((Object)this.request.getPathSegments()).andReturn((Object)ImmutableList.copyOf((Iterable)Iterables.transform(Arrays.asList(requestPath.split("/")), (Function)new Function<String, PathSegment>(){

            public PathSegment apply(final String input) {
                return new PathSegment(){

                    public String getPath() {
                        return input;
                    }

                    public MultivaluedMap<String, String> getMatrixParameters() {
                        return null;
                    }
                };
            }
        }))).anyTimes();
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)requestMethod).anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        AuthenticationResult authenticationResult = new AuthenticationResult("druid", "druid", null);
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).atLeastOnce();
        this.req.setAttribute("Druid-Authorization-Checked", (Object)authCheckResult);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.authorizerMapper.getAuthorizer(EasyMock.anyString())).andReturn((Object)new Authorizer(){

            public Access authorize(AuthenticationResult authenticationResult1, Resource resource, Action action) {
                return new Access(authCheckResult);
            }
        }).atLeastOnce();
    }

    public static Collection<Object[]> getRequestPaths(Class clazz) {
        return ResourceFilterTestHelper.getRequestPaths(clazz, ImmutableList.of(), ImmutableList.of());
    }

    public static Collection<Object[]> getRequestPathsWithAuthorizer(Class clazz) {
        return ResourceFilterTestHelper.getRequestPaths(clazz, ImmutableList.of(AuthorizerMapper.class), ImmutableList.of());
    }

    public static Collection<Object[]> getRequestPaths(Class clazz, Iterable<Class<?>> mockableInjections) {
        return ResourceFilterTestHelper.getRequestPaths(clazz, mockableInjections, ImmutableList.of());
    }

    public static Collection<Object[]> getRequestPaths(Class clazz, Iterable<Class<?>> mockableInjections, Iterable<Key<?>> mockableKeys) {
        return ResourceFilterTestHelper.getRequestPaths(clazz, mockableInjections, mockableKeys, ImmutableList.of());
    }

    public static Collection<Object[]> getRequestPaths(Class clazz, final Iterable<Class<?>> mockableInjections, final Iterable<Key<?>> mockableKeys, final Iterable<?> injectedObjs) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                for (Class clazz : mockableInjections) {
                    binder.bind(clazz).toInstance(EasyMock.createNiceMock((Class)clazz));
                }
                for (Object obj : injectedObjs) {
                    binder.bind(obj.getClass()).toInstance(obj);
                }
                for (Key key : mockableKeys) {
                    binder.bind(key).toInstance(EasyMock.createNiceMock((Class)key.getTypeLiteral().getRawType()));
                }
                binder.bind(AuthConfig.class).toInstance((Object)new AuthConfig(null, null));
            }
        }});
        String basepath = clazz.getAnnotation(Path.class).value().substring(1);
        ImmutableList baseResourceFilters = clazz.getAnnotation(ResourceFilters.class) == null ? Collections.emptyList() : ImmutableList.copyOf((Object[])clazz.getAnnotation(ResourceFilters.class).value());
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)ImmutableList.copyOf((Object[])clazz.getDeclaredMethods()), (Predicate)new Predicate<Method>((List)baseResourceFilters){
            final /* synthetic */ List val$baseResourceFilters;
            {
                this.val$baseResourceFilters = list;
            }

            public boolean apply(Method input) {
                return input.getAnnotation(GET.class) != null || input.getAnnotation(POST.class) != null || input.getAnnotation(DELETE.class) != null && (input.getAnnotation(ResourceFilters.class) != null || !this.val$baseResourceFilters.isEmpty());
            }
        }), (Function)new Function<Method, Collection<Object[]>>((List)baseResourceFilters, basepath, injector){
            final /* synthetic */ List val$baseResourceFilters;
            final /* synthetic */ String val$basepath;
            final /* synthetic */ Injector val$injector;
            {
                this.val$baseResourceFilters = list;
                this.val$basepath = string;
                this.val$injector = injector;
            }

            public Collection<Object[]> apply(final Method method) {
                List resourceFilters = method.getAnnotation(ResourceFilters.class) == null ? this.val$baseResourceFilters : ImmutableList.copyOf((Object[])method.getAnnotation(ResourceFilters.class).value());
                return Collections2.transform((Collection)resourceFilters, (Function)new Function<Class<? extends ResourceFilter>, Object[]>(){

                    public Object[] apply(Class<? extends ResourceFilter> input) {
                        if (method.getAnnotation(Path.class) != null) {
                            Object[] objectArray = new Object[4];
                            objectArray[0] = StringUtils.format((String)"%s%s", (Object[])new Object[]{val$basepath, method.getAnnotation(Path.class).value()});
                            objectArray[1] = input.getAnnotation(GET.class) == null ? (method.getAnnotation(DELETE.class) == null ? "POST" : "DELETE") : "GET";
                            objectArray[2] = val$injector.getInstance(input);
                            objectArray[3] = val$injector;
                            return objectArray;
                        }
                        Object[] objectArray = new Object[4];
                        objectArray[0] = val$basepath;
                        objectArray[1] = input.getAnnotation(GET.class) == null ? (method.getAnnotation(DELETE.class) == null ? "POST" : "DELETE") : "GET";
                        objectArray[2] = val$injector.getInstance(input);
                        objectArray[3] = val$injector;
                        return objectArray;
                    }
                });
            }
        })));
    }
}

