/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.audit.AuditEntry;
import org.apache.hive.druid.io.druid.audit.AuditInfo;
import org.apache.hive.druid.io.druid.audit.AuditManager;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.io.druid.server.http.RulesResource;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RulesResourceTest {
    private MetadataRuleManager databaseRuleManager;
    private AuditManager auditManager;

    @Before
    public void setUp() {
        this.databaseRuleManager = (MetadataRuleManager)EasyMock.createStrictMock(MetadataRuleManager.class);
        this.auditManager = (AuditManager)EasyMock.createStrictMock(AuditManager.class);
    }

    @Test
    public void testGetDatasourceRuleHistoryWithCount() {
        AuditEntry entry1 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-02T00:00:00Z"));
        AuditEntry entry2 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        EasyMock.expect((Object)this.auditManager.fetchAuditHistory((String)EasyMock.eq((Object)"datasource1"), (String)EasyMock.eq((Object)"rules"), EasyMock.eq((int)2))).andReturn((Object)ImmutableList.of((Object)entry1, (Object)entry2)).once();
        EasyMock.replay((Object[])new Object[]{this.auditManager});
        RulesResource rulesResource = new RulesResource(this.databaseRuleManager, this.auditManager);
        Response response = rulesResource.getDatasourceRuleHistory("datasource1", null, Integer.valueOf(2));
        List rulesHistory = (List)response.getEntity();
        Assert.assertEquals((long)2L, (long)rulesHistory.size());
        Assert.assertEquals((Object)entry1, rulesHistory.get(0));
        Assert.assertEquals((Object)entry2, rulesHistory.get(1));
        EasyMock.verify((Object[])new Object[]{this.auditManager});
    }

    @Test
    public void testGetDatasourceRuleHistoryWithInterval() {
        String interval = "P2D/2013-01-02T00:00:00Z";
        Interval theInterval = Intervals.of((String)interval);
        AuditEntry entry1 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-02T00:00:00Z"));
        AuditEntry entry2 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        EasyMock.expect((Object)this.auditManager.fetchAuditHistory((String)EasyMock.eq((Object)"datasource1"), (String)EasyMock.eq((Object)"rules"), (Interval)EasyMock.eq((Object)theInterval))).andReturn((Object)ImmutableList.of((Object)entry1, (Object)entry2)).once();
        EasyMock.replay((Object[])new Object[]{this.auditManager});
        RulesResource rulesResource = new RulesResource(this.databaseRuleManager, this.auditManager);
        Response response = rulesResource.getDatasourceRuleHistory("datasource1", interval, null);
        List rulesHistory = (List)response.getEntity();
        Assert.assertEquals((long)2L, (long)rulesHistory.size());
        Assert.assertEquals((Object)entry1, rulesHistory.get(0));
        Assert.assertEquals((Object)entry2, rulesHistory.get(1));
        EasyMock.verify((Object[])new Object[]{this.auditManager});
    }

    @Test
    public void testGetDatasourceRuleHistoryWithWrongCount() {
        EasyMock.expect((Object)this.auditManager.fetchAuditHistory((String)EasyMock.eq((Object)"datasource1"), (String)EasyMock.eq((Object)"rules"), EasyMock.eq((int)-1))).andThrow((Throwable)new IllegalArgumentException("Limit must be greater than zero!")).once();
        EasyMock.replay((Object[])new Object[]{this.auditManager});
        RulesResource rulesResource = new RulesResource(this.databaseRuleManager, this.auditManager);
        Response response = rulesResource.getDatasourceRuleHistory("datasource1", null, Integer.valueOf(-1));
        Map rulesHistory = (Map)response.getEntity();
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertTrue((boolean)rulesHistory.containsKey("error"));
        Assert.assertEquals((Object)"Limit must be greater than zero!", rulesHistory.get("error"));
        EasyMock.verify((Object[])new Object[]{this.auditManager});
    }

    @Test
    public void testGetAllDatasourcesRuleHistoryWithCount() {
        AuditEntry entry1 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-02T00:00:00Z"));
        AuditEntry entry2 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        EasyMock.expect((Object)this.auditManager.fetchAuditHistory((String)EasyMock.eq((Object)"rules"), EasyMock.eq((int)2))).andReturn((Object)ImmutableList.of((Object)entry1, (Object)entry2)).once();
        EasyMock.replay((Object[])new Object[]{this.auditManager});
        RulesResource rulesResource = new RulesResource(this.databaseRuleManager, this.auditManager);
        Response response = rulesResource.getDatasourceRuleHistory(null, Integer.valueOf(2));
        List rulesHistory = (List)response.getEntity();
        Assert.assertEquals((long)2L, (long)rulesHistory.size());
        Assert.assertEquals((Object)entry1, rulesHistory.get(0));
        Assert.assertEquals((Object)entry2, rulesHistory.get(1));
        EasyMock.verify((Object[])new Object[]{this.auditManager});
    }

    @Test
    public void testGetAllDatasourcesRuleHistoryWithInterval() {
        String interval = "P2D/2013-01-02T00:00:00Z";
        Interval theInterval = Intervals.of((String)interval);
        AuditEntry entry1 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-02T00:00:00Z"));
        AuditEntry entry2 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        EasyMock.expect((Object)this.auditManager.fetchAuditHistory((String)EasyMock.eq((Object)"rules"), (Interval)EasyMock.eq((Object)theInterval))).andReturn((Object)ImmutableList.of((Object)entry1, (Object)entry2)).once();
        EasyMock.replay((Object[])new Object[]{this.auditManager});
        RulesResource rulesResource = new RulesResource(this.databaseRuleManager, this.auditManager);
        Response response = rulesResource.getDatasourceRuleHistory(interval, null);
        List rulesHistory = (List)response.getEntity();
        Assert.assertEquals((long)2L, (long)rulesHistory.size());
        Assert.assertEquals((Object)entry1, rulesHistory.get(0));
        Assert.assertEquals((Object)entry2, rulesHistory.get(1));
        EasyMock.verify((Object[])new Object[]{this.auditManager});
    }

    @Test
    public void testGetAllDatasourcesRuleHistoryWithWrongCount() {
        EasyMock.expect((Object)this.auditManager.fetchAuditHistory((String)EasyMock.eq((Object)"rules"), EasyMock.eq((int)-1))).andThrow((Throwable)new IllegalArgumentException("Limit must be greater than zero!")).once();
        EasyMock.replay((Object[])new Object[]{this.auditManager});
        RulesResource rulesResource = new RulesResource(this.databaseRuleManager, this.auditManager);
        Response response = rulesResource.getDatasourceRuleHistory(null, Integer.valueOf(-1));
        Map rulesHistory = (Map)response.getEntity();
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertTrue((boolean)rulesHistory.containsKey("error"));
        Assert.assertEquals((Object)"Limit must be greater than zero!", rulesHistory.get("error"));
        EasyMock.verify((Object[])new Object[]{this.auditManager});
    }
}

