/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorCleanupOvershadowed;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Test;

public class DruidCoordinatorCleanupOvershadowedTest {
    DruidCoordinatorCleanupOvershadowed druidCoordinatorCleanupOvershadowed;
    DruidCoordinator coordinator = (DruidCoordinator)EasyMock.createStrictMock(DruidCoordinator.class);
    private List<DataSegment> availableSegments;
    DateTime start = DateTimes.of((String)"2012-01-01");
    DruidCluster druidCluster;
    private LoadQueuePeon mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
    private ImmutableDruidServer druidServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
    private ImmutableDruidDataSource druidDataSource = (ImmutableDruidDataSource)EasyMock.createMock(ImmutableDruidDataSource.class);
    private DataSegment segmentV0 = new DataSegment.Builder().dataSource("test").interval(new Interval((ReadableInstant)this.start, (ReadableInstant)this.start.plusHours(1))).version("0").build();
    private DataSegment segmentV1 = new DataSegment.Builder().dataSource("test").interval(new Interval((ReadableInstant)this.start, (ReadableInstant)this.start.plusHours(1))).version("1").build();
    private DataSegment segmentV2 = new DataSegment.Builder().dataSource("test").interval(new Interval((ReadableInstant)this.start, (ReadableInstant)this.start.plusHours(1))).version("2").build();

    @Test
    public void testRun() {
        this.druidCoordinatorCleanupOvershadowed = new DruidCoordinatorCleanupOvershadowed(this.coordinator);
        this.availableSegments = ImmutableList.of((Object)this.segmentV1, (Object)this.segmentV0, (Object)this.segmentV2);
        EasyMock.expect((Object)this.mockPeon.getLoadQueueSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)this.druidServer.getMaxSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)this.druidServer.getCurrSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)this.druidServer.getName()).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.druidServer.getHost()).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.druidServer.getTier()).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.druidServer.getType()).andReturn((Object)ServerType.HISTORICAL).anyTimes();
        EasyMock.expect((Object)this.druidServer.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.druidDataSource)).anyTimes();
        EasyMock.expect((Object)this.druidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)this.segmentV1, (Object)this.segmentV2)).anyTimes();
        EasyMock.expect((Object)this.druidDataSource.getName()).andReturn((Object)"test").anyTimes();
        this.coordinator.removeSegment(this.segmentV1);
        this.coordinator.removeSegment(this.segmentV0);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockPeon, this.coordinator, this.druidServer, this.druidDataSource});
        this.druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(this.druidServer, this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withAvailableSegments(this.availableSegments).withCoordinatorStats(new CoordinatorStats()).withDruidCluster(this.druidCluster).build();
        this.druidCoordinatorCleanupOvershadowed.run(params);
        EasyMock.verify((Object[])new Object[]{this.coordinator, this.druidDataSource, this.druidServer});
    }
}

