/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorBalancerTester;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorBalancer;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorBalancerTest {
    private static final int MAX_SEGMENTS_TO_MOVE = 5;
    private DruidCoordinator coordinator;
    private ImmutableDruidServer druidServer1;
    private ImmutableDruidServer druidServer2;
    private ImmutableDruidServer druidServer3;
    private ImmutableDruidServer druidServer4;
    private List<ImmutableDruidServer> druidServers;
    private LoadQueuePeonTester peon1;
    private LoadQueuePeonTester peon2;
    private LoadQueuePeonTester peon3;
    private LoadQueuePeonTester peon4;
    private List<LoadQueuePeon> peons;
    private DataSegment segment1;
    private DataSegment segment2;
    private DataSegment segment3;
    private DataSegment segment4;
    private Map<String, DataSegment> segments;
    private ListeningExecutorService balancerStrategyExecutor;
    private BalancerStrategy balancerStrategy;

    @Before
    public void setUp() throws Exception {
        this.coordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.druidServer1 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer3 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer4 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.segment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment3 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment4 = (DataSegment)EasyMock.createMock(DataSegment.class);
        DateTime start1 = DateTimes.of((String)"2012-01-01");
        DateTime start2 = DateTimes.of((String)"2012-02-01");
        DateTime version = DateTimes.of((String)"2012-03-01");
        this.segment1 = new DataSegment("datasource1", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 11L);
        this.segment2 = new DataSegment("datasource1", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.segment3 = new DataSegment("datasource2", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 4L);
        this.segment4 = new DataSegment("datasource2", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 8L);
        this.segments = new HashMap<String, DataSegment>();
        this.segments.put("datasource1_2012-01-01T00:00:00.000Z_2012-01-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", this.segment1);
        this.segments.put("datasource1_2012-02-01T00:00:00.000Z_2012-02-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", this.segment2);
        this.segments.put("datasource2_2012-01-01T00:00:00.000Z_2012-01-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", this.segment3);
        this.segments.put("datasource2_2012-02-01T00:00:00.000Z_2012-02-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", this.segment4);
        this.peon1 = new LoadQueuePeonTester();
        this.peon2 = new LoadQueuePeonTester();
        this.peon3 = new LoadQueuePeonTester();
        this.peon4 = new LoadQueuePeonTester();
        this.druidServers = ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2, (Object)this.druidServer3, (Object)this.druidServer4);
        this.peons = ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2), (Object)((Object)this.peon3), (Object)((Object)this.peon4));
        this.balancerStrategyExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        this.balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(this.balancerStrategyExecutor);
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.coordinator});
        EasyMock.verify((Object[])new Object[]{this.druidServer1});
        EasyMock.verify((Object[])new Object[]{this.druidServer2});
        EasyMock.verify((Object[])new Object[]{this.druidServer3});
        EasyMock.verify((Object[])new Object[]{this.druidServer4});
        this.balancerStrategyExecutor.shutdownNow();
    }

    @Test
    public void testMoveToEmptyServerBalancer() throws IOException {
        this.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        this.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyMap());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        this.mockCoordinator(this.coordinator);
        PredefinedPickOrderBalancerStrategy predefinedPickOrderStrategy = new PredefinedPickOrderBalancerStrategy(this.balancerStrategy, (List<BalancerSegmentHolder>)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment2), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment3), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment4)));
        DruidCoordinatorRuntimeParams params = this.defaullRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2))).withBalancerStrategy((BalancerStrategy)predefinedPickOrderStrategy).build();
        params = new DruidCoordinatorBalancerTester(this.coordinator).run(params);
        Assert.assertEquals((long)2L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
    }

    @Test
    public void testMoveSameSegmentTwice() throws Exception {
        this.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        this.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyMap());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        this.mockCoordinator(this.coordinator);
        PredefinedPickOrderBalancerStrategy predefinedPickOrderStrategy = new PredefinedPickOrderBalancerStrategy(this.balancerStrategy, (List<BalancerSegmentHolder>)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1)));
        DruidCoordinatorRuntimeParams params = this.defaullRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2))).withBalancerStrategy((BalancerStrategy)predefinedPickOrderStrategy).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMaxSegmentsToMove(2).build()).build();
        params = new DruidCoordinatorBalancerTester(this.coordinator).run(params);
        Assert.assertEquals((long)1L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
    }

    @Test
    public void testRun1() throws IOException {
        this.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        this.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyMap());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        this.mockCoordinator(this.coordinator);
        DruidCoordinatorRuntimeParams params = this.defaullRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2))).build();
        params = new DruidCoordinatorBalancerTester(this.coordinator).run(params);
        Assert.assertTrue((params.getCoordinatorStats().getTieredStat("movedCount", "normal") > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRun2() throws IOException {
        this.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        this.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyMap());
        this.mockDruidServer(this.druidServer3, "3", "normal", 0L, 100L, Collections.emptyMap());
        this.mockDruidServer(this.druidServer4, "4", "normal", 0L, 100L, Collections.emptyMap());
        this.mockCoordinator(this.coordinator);
        DruidCoordinatorRuntimeParams params = this.defaullRuntimeParamsBuilder(this.druidServers, this.peons).build();
        params = new DruidCoordinatorBalancerTester(this.coordinator).run(params);
        Assert.assertTrue((params.getCoordinatorStats().getTieredStat("movedCount", "normal") > 0L ? 1 : 0) != 0);
    }

    private DruidCoordinatorRuntimeParams.Builder defaullRuntimeParamsBuilder(List<ImmutableDruidServer> druidServers, List<LoadQueuePeon> peons) {
        return DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)IntStream.range(0, druidServers.size()).mapToObj(i -> new ServerHolder((ImmutableDruidServer)druidServers.get(i), (LoadQueuePeon)peons.get(i))).collect(Collectors.toCollection(() -> new TreeSet(DruidCoordinatorBalancer.percentUsedComparator)))))).withLoadManagementPeons(IntStream.range(0, peons.size()).boxed().collect(Collectors.toMap(i -> String.valueOf(i + 1), peons::get))).withAvailableSegments(this.segments.values()).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMaxSegmentsToMove(5).build()).withBalancerStrategy(this.balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01"));
    }

    private void mockDruidServer(ImmutableDruidServer druidServer, String name, String tier, long currentSize, long maxSize, Map<String, DataSegment> segments) {
        EasyMock.expect((Object)druidServer.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)druidServer.getTier()).andReturn((Object)tier).anyTimes();
        EasyMock.expect((Object)druidServer.getCurrSize()).andReturn((Object)currentSize).atLeastOnce();
        EasyMock.expect((Object)druidServer.getMaxSize()).andReturn((Object)maxSize).atLeastOnce();
        EasyMock.expect((Object)druidServer.getSegments()).andReturn(segments).anyTimes();
        if (!segments.isEmpty()) {
            segments.values().forEach(s -> EasyMock.expect((Object)druidServer.getSegment(s.getIdentifier())).andReturn(s).anyTimes());
        } else {
            EasyMock.expect((Object)druidServer.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        }
        EasyMock.replay((Object[])new Object[]{druidServer});
    }

    private void mockCoordinator(DruidCoordinator coordinator) {
        coordinator.moveSegment((ImmutableDruidServer)EasyMock.anyObject(), (ImmutableDruidServer)EasyMock.anyObject(), (DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinator});
    }

    private static class PredefinedPickOrderBalancerStrategy
    implements BalancerStrategy {
        private final BalancerStrategy delegate;
        private final List<BalancerSegmentHolder> pickOrder;
        private final AtomicInteger pickCounter = new AtomicInteger(0);

        public PredefinedPickOrderBalancerStrategy(BalancerStrategy delegate, List<BalancerSegmentHolder> pickOrder) {
            this.delegate = delegate;
            this.pickOrder = pickOrder;
        }

        public ServerHolder findNewSegmentHomeBalancer(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
            return this.delegate.findNewSegmentHomeBalancer(proposalSegment, serverHolders);
        }

        public ServerHolder findNewSegmentHomeReplicator(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
            return this.delegate.findNewSegmentHomeReplicator(proposalSegment, serverHolders);
        }

        public BalancerSegmentHolder pickSegmentToMove(List<ServerHolder> serverHolders) {
            return this.pickOrder.get(this.pickCounter.getAndIncrement() % this.pickOrder.size());
        }

        public void emitStats(String tier, CoordinatorStats stats, List<ServerHolder> serverHolderList) {
            this.delegate.emitStats(tier, stats, serverHolderList);
        }
    }
}

