/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidClusterTest {
    private static final List<DataSegment> segments = ImmutableList.of((Object)new DataSegment("test", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"containerName", (Object)"container1", (Object)"blobPath", (Object)"blobPath1"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L), (Object)new DataSegment("test", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"containerName", (Object)"container2", (Object)"blobPath", (Object)"blobPath2"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L));
    private static final Map<String, ImmutableDruidDataSource> dataSources = ImmutableMap.of((Object)"src1", (Object)new ImmutableDruidDataSource("src1", ImmutableMap.of(), ImmutableMap.of()), (Object)"src2", (Object)new ImmutableDruidDataSource("src2", ImmutableMap.of(), ImmutableMap.of()));
    private static final ServerHolder newRealtime = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host2", null, 100L, ServerType.REALTIME, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)dataSources.get("src1")), ImmutableMap.of((Object)"segment1", (Object)segments.get(0))), (LoadQueuePeon)new LoadQueuePeonTester());
    private static final ServerHolder newHistorical = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host2", null, 100L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)dataSources.get("src1")), ImmutableMap.of((Object)"segment1", (Object)segments.get(0))), (LoadQueuePeon)new LoadQueuePeonTester());
    private DruidCluster cluster;

    @Before
    public void setup() {
        this.cluster = new DruidCluster((Set)ImmutableSet.of((Object)new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.REALTIME, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)dataSources.get("src1")), ImmutableMap.of((Object)"segment1", (Object)segments.get(0))), (LoadQueuePeon)new LoadQueuePeonTester())), (Map)ImmutableMap.of((Object)"tier1", (Object)Stream.of(new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)dataSources.get("src1")), ImmutableMap.of((Object)"segment1", (Object)segments.get(0))), (LoadQueuePeon)new LoadQueuePeonTester())).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((long)1L, (long)this.cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)1L, (long)this.cluster.getRealtimes().size());
        this.cluster.add(newRealtime);
        Assert.assertEquals((long)1L, (long)this.cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)2L, (long)this.cluster.getRealtimes().size());
        this.cluster.add(newHistorical);
        Assert.assertEquals((long)2L, (long)this.cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)2L, (long)this.cluster.getRealtimes().size());
    }

    @Test
    public void testGetAllServers() {
        this.cluster.add(newRealtime);
        this.cluster.add(newHistorical);
        Set expectedRealtimes = this.cluster.getRealtimes();
        Map expectedHistoricals = this.cluster.getHistoricals();
        Collection allServers = this.cluster.getAllServers();
        Assert.assertEquals((long)4L, (long)allServers.size());
        Assert.assertTrue((boolean)allServers.containsAll(this.cluster.getRealtimes()));
        Assert.assertTrue((boolean)allServers.containsAll(this.cluster.getHistoricals().values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
        Assert.assertEquals((Object)expectedHistoricals, (Object)this.cluster.getHistoricals());
        Assert.assertEquals((Object)expectedRealtimes, (Object)this.cluster.getRealtimes());
    }

    @Test
    public void testIsEmpty() {
        DruidCluster emptyCluster = new DruidCluster();
        Assert.assertFalse((boolean)this.cluster.isEmpty());
        Assert.assertTrue((boolean)emptyCluster.isEmpty());
    }
}

