/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.loading.CacheTestSegmentLoader;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.io.druid.server.SegmentManager;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.hive.druid.io.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordination.ZkCoordinatorTest;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentLoadDropHandlerTest {
    public static final int COUNT = 50;
    private static final Logger log = new Logger(ZkCoordinatorTest.class);
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private final DruidServerMetadata me = new DruidServerMetadata("dummyServer", "dummyHost", null, 0L, ServerType.HISTORICAL, "normal", 0);
    private SegmentLoadDropHandler segmentLoadDropHandler;
    private DataSegmentAnnouncer announcer;
    private File infoDir;
    private AtomicInteger announceCount;
    private ConcurrentSkipListSet<DataSegment> segmentsAnnouncedByMe;
    private CacheTestSegmentLoader segmentLoader;
    private SegmentManager segmentManager;
    private List<Runnable> scheduledRunnable;

    @Before
    public void setUp() throws Exception {
        try {
            this.infoDir = new File(File.createTempFile("blah", "blah2").getParent(), "ZkCoordinatorTest");
            this.infoDir.mkdirs();
            for (File file : this.infoDir.listFiles()) {
                file.delete();
            }
            log.info("Creating tmp test files in [%s]", new Object[]{this.infoDir});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.scheduledRunnable = Lists.newArrayList();
        this.segmentLoader = new CacheTestSegmentLoader();
        this.segmentManager = new SegmentManager((SegmentLoader)this.segmentLoader);
        ZkPathsConfig zkPaths = new ZkPathsConfig(){

            public String getBase() {
                return "/druid";
            }
        };
        this.segmentsAnnouncedByMe = new ConcurrentSkipListSet();
        this.announceCount = new AtomicInteger(0);
        this.announcer = new DataSegmentAnnouncer(){

            public void announceSegment(DataSegment segment) throws IOException {
                SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.add(segment);
                SegmentLoadDropHandlerTest.this.announceCount.incrementAndGet();
            }

            public void unannounceSegment(DataSegment segment) throws IOException {
                SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.remove(segment);
                SegmentLoadDropHandlerTest.this.announceCount.decrementAndGet();
            }

            public void announceSegments(Iterable<DataSegment> segments) throws IOException {
                for (DataSegment segment : segments) {
                    SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.add(segment);
                }
                SegmentLoadDropHandlerTest.this.announceCount.addAndGet(Iterables.size(segments));
            }

            public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
                for (DataSegment segment : segments) {
                    SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.remove(segment);
                }
                SegmentLoadDropHandlerTest.this.announceCount.addAndGet(-Iterables.size(segments));
            }
        };
        this.segmentLoadDropHandler = new SegmentLoadDropHandler(this.jsonMapper, new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentLoadDropHandlerTest.this.infoDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        }, this.announcer, (DataSegmentServerAnnouncer)EasyMock.createNiceMock(DataSegmentServerAnnouncer.class), this.segmentManager, new ScheduledExecutorFactory(){

            public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
                return new ScheduledThreadPoolExecutor(corePoolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat).build()){

                    @Override
                    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                        SegmentLoadDropHandlerTest.this.scheduledRunnable.add(command);
                        return null;
                    }
                };
            }
        }.create(5, "SegmentLoadDropHandlerTest-[%d]"));
    }

    @Test
    public void testSegmentLoading1() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment = this.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.segmentLoadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)this.segmentLoader.getSegmentsInTrash().contains(segment));
        this.segmentLoadDropHandler.stop();
    }

    @Test
    public void testSegmentLoading2() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment = this.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)this.segmentLoader.getSegmentsInTrash().contains(segment));
        this.segmentLoadDropHandler.stop();
    }

    @Test
    public void testLoadCache() throws Exception {
        LinkedList segments = Lists.newLinkedList();
        for (int i = 0; i < 50; ++i) {
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-03")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-04")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-05")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T01")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T03")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T05")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T06")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        Collections.sort(segments);
        for (DataSegment segment : segments) {
            this.writeSegmentToCache(segment);
        }
        this.checkCache(segments);
        Assert.assertTrue((boolean)this.segmentManager.getDataSourceCounts().isEmpty());
        this.segmentLoadDropHandler.start();
        Assert.assertTrue((!this.segmentManager.getDataSourceCounts().isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)11L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((long)650L, (long)this.announceCount.get());
        this.segmentLoadDropHandler.stop();
        for (DataSegment segment : segments) {
            this.deleteSegmentFromCache(segment);
        }
        Assert.assertEquals((long)0L, (long)this.infoDir.listFiles().length);
        Assert.assertTrue((boolean)this.infoDir.delete());
    }

    private DataSegment makeSegment(String dataSource, String version, Interval interval) {
        return new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval, (Object)"cacheDir", (Object)this.infoDir), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L);
    }

    private void writeSegmentToCache(DataSegment segment) throws IOException {
        if (!this.infoDir.exists()) {
            this.infoDir.mkdir();
        }
        File segmentInfoCacheFile = new File(this.infoDir, segment.getIdentifier());
        try {
            this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)segmentInfoCacheFile.exists());
    }

    private void deleteSegmentFromCache(DataSegment segment) throws IOException {
        File segmentInfoCacheFile = new File(this.infoDir, segment.getIdentifier());
        if (segmentInfoCacheFile.exists()) {
            segmentInfoCacheFile.delete();
        }
        Assert.assertTrue((!segmentInfoCacheFile.exists() ? 1 : 0) != 0);
    }

    private void checkCache(List<DataSegment> segments) throws IOException {
        Assert.assertTrue((boolean)this.infoDir.exists());
        Object[] files = this.infoDir.listFiles();
        ArrayList sortedFiles = Lists.newArrayList((Object[])files);
        Collections.sort(sortedFiles);
        Assert.assertEquals((long)segments.size(), (long)sortedFiles.size());
        for (int i = 0; i < sortedFiles.size(); ++i) {
            DataSegment segment = (DataSegment)this.jsonMapper.readValue((File)sortedFiles.get(i), DataSegment.class);
            Assert.assertEquals((Object)segments.get(i), (Object)segment);
        }
    }

    @Test
    public void testStartStop() throws Exception {
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.jsonMapper, new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentLoadDropHandlerTest.this.infoDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }
        }, this.announcer, (DataSegmentServerAnnouncer)EasyMock.createNiceMock(DataSegmentServerAnnouncer.class), this.segmentManager);
        LinkedList segments = Lists.newLinkedList();
        for (int i = 0; i < 50; ++i) {
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        Collections.sort(segments);
        for (DataSegment segment : segments) {
            this.writeSegmentToCache(segment);
        }
        this.checkCache(segments);
        Assert.assertTrue((boolean)this.segmentManager.getDataSourceCounts().isEmpty());
        handler.start();
        Assert.assertTrue((!this.segmentManager.getDataSourceCounts().isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)3L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((long)250L, (long)this.announceCount.get());
        handler.stop();
        for (DataSegment segment : segments) {
            this.deleteSegmentFromCache(segment);
        }
        Assert.assertEquals((long)0L, (long)this.infoDir.listFiles().length);
        Assert.assertTrue((boolean)this.infoDir.delete());
    }

    @Test(timeout=1000L)
    public void testProcessBatch() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment1 = this.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        DataSegment segment2 = this.makeSegment("batchtest2", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1), (Object)new SegmentChangeRequestDrop(segment2));
        ListenableFuture future = this.segmentLoadDropHandler.processBatch((List)batch);
        List result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.PENDING, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus());
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(1)).getStatus());
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)this.segmentLoadDropHandler.processBatch((List)batch).get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus());
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(1)).getStatus());
        for (SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus e : (List)this.segmentLoadDropHandler.processBatch((List)batch).get()) {
            Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)e.getStatus());
        }
        this.segmentLoadDropHandler.stop();
    }
}

