/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.JSONParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.initialization.Initialization;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorFactory;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorImpl;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorTest;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.Committers;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DefaultOfflineAppenderatorFactoryTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testBuild() throws IOException, SegmentNotWritableException {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/tool");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(9999);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.bind(DruidProcessingConfig.class).toInstance((Object)new DruidProcessingConfig(){

                    public String getFormatString() {
                        return "processing-%s";
                    }

                    public int intermediateComputeSizeBytes() {
                        return 0x6400000;
                    }

                    public int getNumThreads() {
                        return 1;
                    }

                    public int columnCacheSizeBytes() {
                        return 0x1900000;
                    }
                });
                binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
            }
        }));
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        AppenderatorFactory defaultOfflineAppenderatorFactory = (AppenderatorFactory)objectMapper.reader(AppenderatorFactory.class).readValue("{\"type\":\"offline\"}");
        Map parserMap = (Map)objectMapper.convertValue((Object)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("ts", "auto", null), new DimensionsSpec(null, null, null), null, null)), Map.class);
        DataSchema schema = new DataSchema("dataSourceName", parserMap, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null), null, objectMapper);
        RealtimeTuningConfig tuningConfig = new RealtimeTuningConfig(Integer.valueOf(75000), null, null, this.temporaryFolder.newFolder(), null, null, null, null, null, null, 0, 0, null, null, null, null);
        try (Appenderator appenderator = defaultOfflineAppenderatorFactory.build(schema, tuningConfig, new FireDepartmentMetrics());){
            Assert.assertEquals((Object)"dataSourceName", (Object)appenderator.getDataSource());
            Assert.assertEquals(null, (Object)appenderator.startJob());
            SegmentIdentifier identifier = new SegmentIdentifier("dataSourceName", Intervals.of((String)"2000/2001"), "A", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(identifier, AppenderatorTest.IR("2000", "bar", 1L), Suppliers.ofInstance((Object)Committers.nil()));
            Assert.assertEquals((long)1L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(identifier, AppenderatorTest.IR("2000", "baz", 1L), Suppliers.ofInstance((Object)Committers.nil()));
            Assert.assertEquals((long)2L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.close();
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
        }
    }
}

