/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Committed;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class CommittedTest {
    private static final ObjectMapper objectMapper = new DefaultObjectMapper();
    private static final SegmentIdentifier IDENTIFIER_OBJECT1 = new SegmentIdentifier("foo", Intervals.of((String)"2000/2001"), "2000", (ShardSpec)new LinearShardSpec(Integer.valueOf(1)));
    private static final SegmentIdentifier IDENTIFIER_OBJECT2 = new SegmentIdentifier("foo", Intervals.of((String)"2001/2002"), "2001", (ShardSpec)new LinearShardSpec(Integer.valueOf(1)));
    private static final SegmentIdentifier IDENTIFIER_OBJECT3 = new SegmentIdentifier("foo", Intervals.of((String)"2001/2002"), "2001", (ShardSpec)new LinearShardSpec(Integer.valueOf(2)));
    private static final String IDENTIFIER1 = IDENTIFIER_OBJECT1.getIdentifierAsString();
    private static final String IDENTIFIER2 = IDENTIFIER_OBJECT2.getIdentifierAsString();
    private static final String IDENTIFIER3 = IDENTIFIER_OBJECT3.getIdentifierAsString();

    private static Committed fixedInstance() {
        HashMap hydrants = Maps.newHashMap();
        hydrants.put(IDENTIFIER1, 3);
        hydrants.put(IDENTIFIER2, 2);
        return new Committed((Map)hydrants, (Object)ImmutableMap.of((Object)"metadata", (Object)"foo"));
    }

    @Test
    public void testFactoryMethod() {
        Committed committed = CommittedTest.fixedInstance();
        Committed committed2 = Committed.create((Map)ImmutableMap.of((Object)IDENTIFIER_OBJECT1, (Object)3, (Object)IDENTIFIER_OBJECT2, (Object)2), (Object)ImmutableMap.of((Object)"metadata", (Object)"foo"));
        Assert.assertEquals((Object)committed, (Object)committed2);
    }

    @Test
    public void testSerde() throws Exception {
        Committed committed = CommittedTest.fixedInstance();
        byte[] bytes = objectMapper.writeValueAsBytes((Object)committed);
        Committed committed2 = (Committed)objectMapper.readValue(bytes, Committed.class);
        Assert.assertEquals((String)"Round trip: overall", (Object)committed, (Object)committed2);
        Assert.assertEquals((String)"Round trip: metadata", (Object)committed.getMetadata(), (Object)committed2.getMetadata());
        Assert.assertEquals((String)"Round trip: identifiers", (Object)committed.getHydrants().keySet(), (Object)committed2.getHydrants().keySet());
    }

    @Test
    public void testGetCommittedHydrant() {
        Assert.assertEquals((long)3L, (long)CommittedTest.fixedInstance().getCommittedHydrants(IDENTIFIER1));
        Assert.assertEquals((long)2L, (long)CommittedTest.fixedInstance().getCommittedHydrants(IDENTIFIER2));
        Assert.assertEquals((long)0L, (long)CommittedTest.fixedInstance().getCommittedHydrants(IDENTIFIER3));
    }

    @Test
    public void testWithout() throws Exception {
        Assert.assertEquals((long)0L, (long)CommittedTest.fixedInstance().without(IDENTIFIER1).getCommittedHydrants(IDENTIFIER1));
        Assert.assertEquals((long)2L, (long)CommittedTest.fixedInstance().without(IDENTIFIER1).getCommittedHydrants(IDENTIFIER2));
    }
}

