/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.segment.loading.StorageLocation;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class StorageLocationTest {
    @Test
    public void testStorageLocation() throws Exception {
        long expectedAvail = 1000L;
        StorageLocation loc = new StorageLocation(new File("/tmp"), expectedAvail, null);
        this.verifyLoc(expectedAvail, loc);
        DataSegment secondSegment = this.makeSegment("2012-01-02/2012-01-03", 23L);
        loc.addSegment(this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail -= 10L, loc);
        loc.addSegment(this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.addSegment(secondSegment);
        this.verifyLoc(expectedAvail -= 23L, loc);
        loc.removeSegment(this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail += 10L, loc);
        loc.removeSegment(this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.removeSegment(secondSegment);
        this.verifyLoc(expectedAvail += 23L, loc);
    }

    private void verifyLoc(long maxSize, StorageLocation loc) {
        Assert.assertEquals((long)maxSize, (long)loc.available());
        int i = 0;
        while ((long)i <= maxSize) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)loc.canHandle(this.makeSegment("2013/2014", i)));
            ++i;
        }
    }

    private DataSegment makeSegment(String intervalString, long size) {
        return new DataSegment("test", Intervals.of((String)intervalString), "1", (Map)ImmutableMap.of(), Arrays.asList("d"), Arrays.asList("m"), null, null, size);
    }
}

