/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.query.filter.IntervalDimFilter;
import org.apache.hive.druid.io.druid.query.filter.JavaScriptDimFilter;
import org.apache.hive.druid.io.druid.query.filter.RegexDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SearchQueryDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.search.ContainsSearchQuerySpec;
import org.apache.hive.druid.io.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.io.druid.segment.IndexBuilder;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.filter.BaseFilterTest;
import org.joda.time.DateTimeZone;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeFilteringTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "ts";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("ts", "millis", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)0L, (Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)1L, (Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)2L, (Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)3L, (Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)4L, (Object)"dim0", (Object)"4", (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)5L, (Object)"dim0", (Object)"5", (Object)"dim1", (Object)"abc")).get(0));

    public TimeFilteringTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(TimeFilteringTest.class.getName());
    }

    @Test
    public void testTimeFilterAsLong() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("__time", "0", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("__time", "9000", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("__time", "0", "4", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("__time", "0", "4", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new InDimFilter("__time", Arrays.asList("2", "4", "8"), null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        ArrayList<String> infilterValues = new ArrayList<String>(32);
        for (int i = 0; i < 32; ++i) {
            infilterValues.add(String.valueOf(i * 2));
        }
        this.assertFilterMatches((DimFilter)new InDimFilter("__time", infilterValues, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
        String jsFn = "function(x) { return(x === 3 || x === 5) }";
        this.assertFilterMatches((DimFilter)new JavaScriptDimFilter("__time", jsFn, null, JavaScriptConfig.getEnabledInstance()), (List<String>)ImmutableList.of((Object)"3", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("__time", "4", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("__time", (SearchQuerySpec)new ContainsSearchQuerySpec("2", true), null), (List<String>)ImmutableList.of((Object)"2"));
    }

    @Test
    public void testTimeFilterWithExtractionFn() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put("0", "Monday");
        stringMap.put("1", "Tuesday");
        stringMap.put("2", "Wednesday");
        stringMap.put("3", "Thursday");
        stringMap.put("4", "Friday");
        stringMap.put("5", "Saturday");
        MapLookupExtractor mapExtractor = new MapLookupExtractor(stringMap, false);
        LookupExtractionFn exfn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", false, Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("__time", "Monday", (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("__time", "Notaday", (ExtractionFn)exfn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("__time", "Fridax", "Fridaz", Boolean.valueOf(false), Boolean.valueOf(false), null, (ExtractionFn)exfn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("__time", "Friday", "Friday", Boolean.valueOf(true), Boolean.valueOf(true), null, (ExtractionFn)exfn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new InDimFilter("__time", Arrays.asList("Caturday", "Saturday", "Tuesday"), (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
        List<String> bigList = Arrays.asList("Saturday", "Tuesday", "Caturday", "Xanaday", "Vojuday", "Gribaday", "Kipoday", "Dheferday", "Fakeday", "Qeearaday", "Hello", "World", "1", "2", "3", "4", "5", "6", "7");
        this.assertFilterMatches((DimFilter)new InDimFilter("__time", bigList, (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
        String jsFn = "function(x) { return(x === 'Wednesday' || x === 'Thursday') }";
        this.assertFilterMatches((DimFilter)new JavaScriptDimFilter("__time", jsFn, (ExtractionFn)exfn, JavaScriptConfig.getEnabledInstance()), (List<String>)ImmutableList.of((Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("__time", ".*day", (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("__time", (SearchQuerySpec)new ContainsSearchQuerySpec("s", true), (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
    }

    @Test
    public void testTimeFilterWithTimeFormatExtractionFn() {
        TimeFormatExtractionFn exfn = new TimeFormatExtractionFn("EEEE", DateTimeZone.forID((String)"America/New_York"), "en", null, false);
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("__time", "Wednesday", (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testIntervalFilter() {
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.005Z")), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-01T00:00:00.003Z"), Intervals.of((String)"1970-01-01T00:00:00.004Z/1970-01-01T00:00:00.006Z")), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-01T00:00:00.001Z"), Intervals.of((String)"1970-01-01T00:00:00.003Z/1970-01-01T00:00:00.006Z"), Intervals.of((String)"1970-01-01T00:00:00.002Z/1970-01-01T00:00:00.005Z")), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        String timeBoosterJsFn = "function(x) { return(x + 7200000) }";
        JavaScriptExtractionFn exFn = new JavaScriptExtractionFn(timeBoosterJsFn, true, JavaScriptConfig.getEnabledInstance());
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T02:00:00.001Z/1970-01-01T02:00:00.005Z")), (ExtractionFn)exFn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
    }

    @Test
    public void testIntervalFilterOnStringDimension() {
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("dim0", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.005Z")), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("dim0", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-01T00:00:00.003Z"), Intervals.of((String)"1970-01-01T00:00:00.004Z/1970-01-01T00:00:00.006Z")), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("dim0", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-01T00:00:00.001Z"), Intervals.of((String)"1970-01-01T00:00:00.003Z/1970-01-01T00:00:00.006Z"), Intervals.of((String)"1970-01-01T00:00:00.002Z/1970-01-01T00:00:00.005Z")), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("dim1", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.002Z/1970-01-01T00:00:00.011Z")), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
        String timeBoosterJsFn = "function(x) { return(Number(x) + 7200000) }";
        JavaScriptExtractionFn exFn = new JavaScriptExtractionFn(timeBoosterJsFn, true, JavaScriptConfig.getEnabledInstance());
        this.assertFilterMatches((DimFilter)new IntervalDimFilter("dim0", Arrays.asList(Intervals.of((String)"1970-01-01T02:00:00.001Z/1970-01-01T02:00:00.005Z")), (ExtractionFn)exFn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
    }
}

