/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.io.druid.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.io.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilters;
import org.apache.hive.druid.io.druid.query.filter.ExtractionDimFilter;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.data.ArrayIndexed;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.apache.hive.druid.io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExtractionDimFilterTest {
    private static final Map<String, String[]> DIM_VALS = ImmutableMap.of((Object)"foo", (Object)new String[]{"foo1", "foo2", "foo3"}, (Object)"bar", (Object)new String[]{"bar1"}, (Object)"baz", (Object)new String[]{"foo1"});
    private static final Map<String, String> EXTRACTION_VALUES = ImmutableMap.of((Object)"foo1", (Object)"extractDimVal");
    private final BitmapFactory factory;
    private final BitmapSerdeFactory serdeFactory;
    private final ImmutableBitmap foo1BitMap;
    private final BitmapIndexSelector BITMAP_INDEX_SELECTOR = new BitmapIndexSelector(){

        public Indexed<String> getDimensionValues(String dimension) {
            Object[] vals = (String[])DIM_VALS.get(dimension);
            return vals == null ? null : new ArrayIndexed(vals, String.class);
        }

        public boolean hasMultipleValues(String dimension) {
            return true;
        }

        public int getNumRows() {
            return 1;
        }

        public BitmapFactory getBitmapFactory() {
            return ExtractionDimFilterTest.this.factory;
        }

        public ImmutableBitmap getBitmapIndex(String dimension, String value) {
            return "foo1".equals(value) ? ExtractionDimFilterTest.this.foo1BitMap : null;
        }

        public BitmapIndex getBitmapIndex(String dimension) {
            return new BitmapIndexColumnPartSupplier(ExtractionDimFilterTest.this.factory, GenericIndexed.fromIterable(Arrays.asList(ExtractionDimFilterTest.this.foo1BitMap), (ObjectStrategy)ExtractionDimFilterTest.this.serdeFactory.getObjectStrategy()), GenericIndexed.fromIterable(Arrays.asList("foo1"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY)).get();
        }

        public ImmutableRTree getSpatialIndex(String dimension) {
            return null;
        }
    };
    private static final ExtractionFn DIM_EXTRACTION_FN = new DimExtractionFn(){

        public byte[] getCacheKey() {
            return new byte[0];
        }

        public String apply(String dimValue) {
            String retval = (String)EXTRACTION_VALUES.get(dimValue);
            return retval == null ? dimValue : retval;
        }

        public boolean preservesOrdering() {
            return false;
        }

        public ExtractionFn.ExtractionType getExtractionType() {
            return ExtractionFn.ExtractionType.MANY_TO_ONE;
        }
    };

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{new ConciseBitmapFactory(), new ConciseBitmapSerdeFactory()}, (Object)new Object[]{new RoaringBitmapFactory(), new RoaringBitmapSerdeFactory(null)});
    }

    public ExtractionDimFilterTest(BitmapFactory bitmapFactory, BitmapSerdeFactory bitmapSerdeFactory) {
        MutableBitmap mutableBitmap = bitmapFactory.makeEmptyMutableBitmap();
        mutableBitmap.add(1);
        this.foo1BitMap = bitmapFactory.makeImmutableBitmap(mutableBitmap);
        this.factory = bitmapFactory;
        this.serdeFactory = bitmapSerdeFactory;
    }

    @Test
    public void testEmpty() {
        Filter extractionFilter = new SelectorDimFilter("foo", "NFDJUKFNDSJFNS", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNull() {
        Filter extractionFilter = new SelectorDimFilter("FDHJSFFHDS", "extractDimVal", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNormal() {
        Filter extractionFilter = new SelectorDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)1L, (long)immutableBitmap.size());
    }

    @Test
    public void testOr() {
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testAnd() {
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.and((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testNot() {
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.not((DimFilter)new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null))).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }
}

