/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.segment.data.VSizeLongSerde;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VSizeLongSerdeTest {
    private ByteBuffer buffer;
    private ByteArrayOutputStream outStream;
    private ByteBuffer outBuffer;
    private long[] values0 = new long[]{0L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 1L};
    private long[] values1 = new long[]{0L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 1L};
    private long[] values2 = new long[]{12L, 5L, 2L, 9L, 3L, 2L, 5L, 1L, 0L, 6L, 13L, 10L, 15L};
    private long[] values3 = new long[]{1L, 1L, 1L, 1L, 1L, 11L, 11L, 11L, 11L};
    private long[] values4 = new long[]{200L, 200L, 200L, 401L, 200L, 301L, 200L, 200L, 200L, 404L, 200L, 200L, 200L, 200L};
    private long[] values5 = new long[]{123L, 632L, 12L, 39L, 536L, 0L, 1023L, 52L, 777L, 526L, 214L, 562L, 823L, 346L};
    private long[] values6 = new long[]{1000000L, 1000001L, 1000002L, 1000003L, 1000004L, 1000005L, 1000006L, 1000007L, 1000008L};

    @Before
    public void setUp() {
        this.outStream = new ByteArrayOutputStream();
        this.outBuffer = ByteBuffer.allocate(500000);
    }

    @Test
    public void testGetBitsForMax() {
        Assert.assertEquals((long)1L, (long)VSizeLongSerde.getBitsForMax((long)1L));
        Assert.assertEquals((long)1L, (long)VSizeLongSerde.getBitsForMax((long)2L));
        Assert.assertEquals((long)2L, (long)VSizeLongSerde.getBitsForMax((long)3L));
        Assert.assertEquals((long)4L, (long)VSizeLongSerde.getBitsForMax((long)16L));
        Assert.assertEquals((long)8L, (long)VSizeLongSerde.getBitsForMax((long)200L));
        Assert.assertEquals((long)12L, (long)VSizeLongSerde.getBitsForMax((long)999L));
        Assert.assertEquals((long)24L, (long)VSizeLongSerde.getBitsForMax((long)12345678L));
        Assert.assertEquals((long)32L, (long)VSizeLongSerde.getBitsForMax((long)Integer.MAX_VALUE));
        Assert.assertEquals((long)64L, (long)VSizeLongSerde.getBitsForMax((long)Long.MAX_VALUE));
    }

    @Test
    public void testSerdeValues() throws IOException {
        for (int i : VSizeLongSerde.SUPPORTED_SIZES) {
            this.testSerde(i, this.values0);
            if (i >= 1) {
                this.testSerde(i, this.values1);
            }
            if (i >= 4) {
                this.testSerde(i, this.values2);
                this.testSerde(i, this.values3);
            }
            if (i >= 9) {
                this.testSerde(i, this.values4);
            }
            if (i >= 10) {
                this.testSerde(i, this.values5);
            }
            if (i < 20) continue;
            this.testSerde(i, this.values6);
        }
    }

    @Test
    public void testSerdeLoop() throws IOException {
        for (int i : VSizeLongSerde.SUPPORTED_SIZES) {
            if (i >= 8) {
                this.testSerdeIncLoop(i, 0L, 256L);
            }
            if (i < 16) continue;
            this.testSerdeIncLoop(i, 0L, 50000L);
        }
    }

    public void testSerde(int longSize, long[] values) throws IOException {
        this.outBuffer.rewind();
        this.outStream.reset();
        VSizeLongSerde.LongSerializer streamSer = VSizeLongSerde.getSerializer((int)longSize, (OutputStream)this.outStream);
        VSizeLongSerde.LongSerializer bufferSer = VSizeLongSerde.getSerializer((int)longSize, (ByteBuffer)this.outBuffer, (int)0);
        for (long value : values) {
            streamSer.write(value);
            bufferSer.write(value);
        }
        streamSer.close();
        bufferSer.close();
        this.buffer = ByteBuffer.wrap(this.outStream.toByteArray());
        Assert.assertEquals((long)VSizeLongSerde.getSerializedSize((int)longSize, (int)values.length), (long)this.buffer.capacity());
        Assert.assertEquals((long)VSizeLongSerde.getSerializedSize((int)longSize, (int)values.length), (long)this.outBuffer.position());
        VSizeLongSerde.LongDeserializer streamDes = VSizeLongSerde.getDeserializer((int)longSize, (ByteBuffer)this.buffer, (int)0);
        VSizeLongSerde.LongDeserializer bufferDes = VSizeLongSerde.getDeserializer((int)longSize, (ByteBuffer)this.outBuffer, (int)0);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((long)values[i], (long)streamDes.get(i));
            Assert.assertEquals((long)values[i], (long)bufferDes.get(i));
        }
    }

    public void testSerdeIncLoop(int longSize, long start, long end) throws IOException {
        this.outBuffer.rewind();
        this.outStream.reset();
        VSizeLongSerde.LongSerializer streamSer = VSizeLongSerde.getSerializer((int)longSize, (OutputStream)this.outStream);
        VSizeLongSerde.LongSerializer bufferSer = VSizeLongSerde.getSerializer((int)longSize, (ByteBuffer)this.outBuffer, (int)0);
        for (long i = start; i < end; ++i) {
            streamSer.write(i);
            bufferSer.write(i);
        }
        streamSer.close();
        bufferSer.close();
        this.buffer = ByteBuffer.wrap(this.outStream.toByteArray());
        Assert.assertEquals((long)VSizeLongSerde.getSerializedSize((int)longSize, (int)((int)(end - start))), (long)this.buffer.capacity());
        Assert.assertEquals((long)VSizeLongSerde.getSerializedSize((int)longSize, (int)((int)(end - start))), (long)this.outBuffer.position());
        VSizeLongSerde.LongDeserializer streamDes = VSizeLongSerde.getDeserializer((int)longSize, (ByteBuffer)this.buffer, (int)0);
        VSizeLongSerde.LongDeserializer bufferDes = VSizeLongSerde.getDeserializer((int)longSize, (ByteBuffer)this.outBuffer, (int)0);
        int i = 0;
        while ((long)i < end - start) {
            Assert.assertEquals((long)(start + (long)i), (long)streamDes.get(i));
            Assert.assertEquals((long)(start + (long)i), (long)bufferDes.get(i));
            ++i;
        }
    }
}

