/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableMultiset;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.data.IncrementalIndexTest;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IndexMergerNullHandlingTest {
    private IndexMerger indexMerger;
    private IndexIO indexIO;
    private IndexSpec indexSpec;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() {
        this.indexMerger = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.indexIO = TestHelper.getTestIndexIO((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.indexSpec = new IndexSpec();
    }

    @Test
    public void testStringColumnNullHandling() throws Exception {
        ArrayList<ImmutableMap> nonNullFlavors = new ArrayList<ImmutableMap>();
        nonNullFlavors.add(ImmutableMap.of((Object)"d", (Object)"a"));
        nonNullFlavors.add(ImmutableMap.of((Object)"d", (Object)ImmutableList.of((Object)"a", (Object)"b")));
        ArrayList<Object> nullFlavors = new ArrayList<Object>();
        ImmutableMap mMissing = ImmutableMap.of();
        ImmutableMap mEmptyList = ImmutableMap.of((Object)"d", Collections.emptyList());
        HashMap<String, Object> mNull = new HashMap<String, Object>();
        mNull.put("d", null);
        ImmutableMap mEmptyString = ImmutableMap.of((Object)"d", (Object)"");
        ImmutableMap mListOfNull = ImmutableMap.of((Object)"d", Collections.singletonList(null));
        ImmutableMap mListOfEmptyString = ImmutableMap.of((Object)"d", Collections.singletonList(""));
        nullFlavors.add(mMissing);
        nullFlavors.add(mEmptyList);
        nullFlavors.add(mNull);
        nullFlavors.add(mEmptyString);
        nullFlavors.add(mListOfNull);
        nullFlavors.add(mListOfEmptyString);
        HashSet<Object> allValues = new HashSet<Object>();
        allValues.addAll(nonNullFlavors);
        allValues.addAll(nullFlavors);
        for (Set subset : Sets.powerSet(allValues)) {
            if (subset.isEmpty()) continue;
            ArrayList subsetList = new ArrayList(subset);
            IncrementalIndex toPersist = IncrementalIndexTest.createIndex(new AggregatorFactory[0]);
            for (Map m2 : subsetList) {
                toPersist.add((InputRow)new MapBasedInputRow(0L, (List)ImmutableList.of((Object)"d"), m2));
            }
            File tempDir = this.temporaryFolder.newFolder();
            QueryableIndex index = this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null));
            Throwable throwable = null;
            try {
                Column column = index.getColumn("d");
                if (subsetList.stream().allMatch(nullFlavors::contains)) {
                    Assert.assertNull((String)((Object)subsetList).toString(), (Object)column);
                    continue;
                }
                Assert.assertNotNull((String)((Object)subsetList).toString(), (Object)column);
                boolean hasMultipleValues = subsetList.stream().anyMatch(m -> m.get("d") instanceof List && ((List)m.get("d")).size() > 1);
                HashSet<String> uniqueValues = new HashSet<String>();
                for (Map m3 : subsetList) {
                    List<String> dValues = IndexMergerNullHandlingTest.normalize(m3.get("d"), hasMultipleValues);
                    uniqueValues.addAll(dValues);
                    if (!nullFlavors.contains(m3)) continue;
                    uniqueValues.add(null);
                }
                DictionaryEncodedColumn dictionaryColumn = column.getDictionaryEncoding();
                Throwable throwable2 = null;
                try {
                    Assert.assertEquals((String)((Object)subsetList).toString(), uniqueValues.stream().sorted(Comparators.naturalNullsFirst()).collect(Collectors.toList()), IntStream.range(0, dictionaryColumn.getCardinality()).mapToObj(arg_0 -> ((DictionaryEncodedColumn)dictionaryColumn).lookupName(arg_0)).collect(Collectors.toList()));
                    Assert.assertEquals((String)((Object)subsetList).toString(), (Object)hasMultipleValues, (Object)dictionaryColumn.hasMultipleValues());
                    Assert.assertEquals((String)((Object)subsetList).toString(), (long)uniqueValues.size(), (long)dictionaryColumn.getCardinality());
                    Assert.assertEquals((String)((Object)subsetList).toString(), (Object)ImmutableMultiset.copyOf((Iterable)subsetList.stream().map(m -> IndexMergerNullHandlingTest.normalize(m.get("d"), hasMultipleValues)).distinct().collect(Collectors.toList())), (Object)ImmutableMultiset.copyOf((Iterable)IntStream.range(0, index.getNumRows()).mapToObj(rowNumber -> IndexMergerNullHandlingTest.getRow((DictionaryEncodedColumn<String>)dictionaryColumn, rowNumber)).distinct().collect(Collectors.toList())));
                    BitmapIndex bitmapIndex = column.getBitmapIndex();
                    ArrayList<Integer> expectedNullRows = new ArrayList<Integer>();
                    for (int i = 0; i < index.getNumRows(); ++i) {
                        List<String> row = IndexMergerNullHandlingTest.getRow((DictionaryEncodedColumn<String>)dictionaryColumn, i);
                        if (!row.isEmpty() && !row.stream().anyMatch(Strings::isNullOrEmpty)) continue;
                        expectedNullRows.add(i);
                    }
                    Assert.assertEquals((String)((Object)subsetList).toString(), (Object)(expectedNullRows.size() > 0 ? 1 : 0), (Object)bitmapIndex.hasNulls());
                    if (expectedNullRows.size() > 0) {
                        Assert.assertEquals((String)((Object)subsetList).toString(), (long)0L, (long)bitmapIndex.getIndex(null));
                        ImmutableBitmap nullBitmap = bitmapIndex.getBitmap(bitmapIndex.getIndex(null));
                        ArrayList<Integer> actualNullRows = new ArrayList<Integer>();
                        IntIterator iterator = nullBitmap.iterator();
                        while (iterator.hasNext()) {
                            actualNullRows.add(iterator.next());
                        }
                        Assert.assertEquals((String)((Object)subsetList).toString(), expectedNullRows, actualNullRows);
                        continue;
                    }
                    Assert.assertEquals((long)-1L, (long)bitmapIndex.getIndex(null));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (dictionaryColumn == null) continue;
                    if (throwable2 != null) {
                        try {
                            dictionaryColumn.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    dictionaryColumn.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (index == null) continue;
                if (throwable != null) {
                    try {
                        index.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                index.close();
            }
        }
    }

    private static List<String> normalize(Object value, boolean hasMultipleValues) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (value == null) {
            if (!hasMultipleValues) {
                retVal.add(null);
            }
        } else if (value instanceof String) {
            retVal.add(Strings.emptyToNull((String)((String)value)));
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty() && !hasMultipleValues) {
                retVal.add(null);
            } else {
                retVal.addAll(list.stream().map(Strings::emptyToNull).collect(Collectors.toList()));
            }
        } else {
            throw new ISE("didn't expect class[%s]", new Object[]{value.getClass()});
        }
        return retVal;
    }

    private static List<String> getRow(DictionaryEncodedColumn<String> column, int rowNumber) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (column.hasMultipleValues()) {
            column.getMultiValueRow(rowNumber).forEach(i -> retVal.add((String)((Object)column.lookupName(i))));
        } else {
            retVal.add((String)((Object)column.lookupName(column.getSingleValueRow(rowNumber))));
        }
        return retVal;
    }
}

