/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.hive.druid.io.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.io.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.InDimFilter;
import org.apache.hive.druid.io.druid.query.filter.NotDimFilter;
import org.apache.hive.druid.io.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.io.druid.query.filter.RegexDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.VirtualColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryRunnerTest {
    public static final Map<String, Object> CONTEXT = ImmutableMap.of();
    protected final QueryRunner runner;
    protected final boolean descending;
    private final List<AggregatorFactory> aggregatorFactoryList;

    @Parameterized.Parameters(name="{0}:descending={1}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(QueryRunnerTestHelper.makeQueryRunners(new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)), Arrays.asList(false, true), Arrays.asList(QueryRunnerTestHelper.commonDoubleAggregators, QueryRunnerTestHelper.commonFloatAggregators));
    }

    private <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        if (this.descending) {
            expectedResults = TestHelper.revert(expectedResults);
        }
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    public TimeseriesQueryRunnerTest(QueryRunner runner, boolean descending, List<AggregatorFactory> aggregatorFactoryList) {
        this.runner = runner;
        this.descending = descending;
        this.aggregatorFactoryList = aggregatorFactoryList;
    }

    @Test
    public void testEmptyTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.emptyInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum, new DoubleFirstAggregatorFactory("first", "index"))).descending(this.descending).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2020-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"first", (Object)0.0))));
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testFullOnTimeseries() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        String[] expectedIndex = this.descending ? QueryRunnerTestHelper.expectedFullOnIndexValuesDesc : QueryRunnerTestHelper.expectedFullOnIndexValues;
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.earliest : QueryRunnerTestHelper.last;
        int count = 0;
        Result lastResult = null;
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.skippedDay.equals((Object)current) ? 0L : 13L), (long)value.getLongMetric("rows"));
            Assert.assertEquals((String)result.toString(), (double)Doubles.tryParse((String)expectedIndex[count]), (double)value.getDoubleMetric("index"), (double)(value.getDoubleMetric("index") * 1.0E-6));
            Assert.assertEquals((String)result.toString(), (double)(new Double(expectedIndex[count]) + (double)(QueryRunnerTestHelper.skippedDay.equals((Object)current) ? 0L : 13L) + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)(value.getDoubleMetric("addRowsIndexConstant") * 1.0E-6));
            Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)(QueryRunnerTestHelper.skippedDay.equals((Object)current) ? 0.0 : 9.0), (double)0.02);
            lastResult = result;
            ++count;
        }
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testTimeseriesNoAggregators() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.fullOnInterval).descending(this.descending).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.earliest : QueryRunnerTestHelper.last;
        Result lastResult = null;
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            Assert.assertEquals((Object)ImmutableMap.of(), (Object)((TimeseriesResultValue)result.getValue()).getBaseObject());
            lastResult = result;
        }
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testFullOnTimeseriesMaxMin() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index"))).descending(this.descending).build();
        DateTime expectedEarliest = DateTimes.of((String)"2011-01-12");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
        Assert.assertEquals((String)result.toString(), (double)1870.061029, (double)value.getDoubleMetric("maxIndex"), (double)0.0018700610289999998);
        Assert.assertEquals((String)result.toString(), (double)59.021022, (double)value.getDoubleMetric("minIndex"), (double)5.9021021999999996E-5);
    }

    @Test
    public void testFullOnTimeseriesWithFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "upfront").intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.qualityUniques)).descending(this.descending).build();
        Assert.assertEquals((Object)new SelectorDimFilter("market", "upfront", null), (Object)query.getDimensionsFilter());
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.earliest : QueryRunnerTestHelper.last;
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.skippedDay.equals((Object)result.getTimestamp()) ? 0L : 2L), (long)value.getLongMetric("rows"));
            Assert.assertEquals((String)result.toString(), (double)(QueryRunnerTestHelper.skippedDay.equals((Object)result.getTimestamp()) ? 0.0 : 2.0), (double)value.getDoubleMetric("uniques"), (double)0.01);
        }
    }

    @Test
    public void testTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithVirtualColumn() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "expr"), QueryRunnerTestHelper.qualityUniques)).descending(this.descending).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "index", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithTimeZone() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals("2011-03-31T00:00:00-07:00/2011-04-02T00:00:00-07:00").aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).granularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.forID((String)"America/Los_Angeles"))).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-03-31", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L))), new Result(new DateTime((Object)"2011-04-01T", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithVaryingGran() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).descending(this.descending).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query1), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity("DAY").intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults2 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query2), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesGranularityNotAlignedOnSegmentBoundariesWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"P7D"), null, DateTimeZone.forID((String)"America/Los_Angeles"))).intervals(Collections.singletonList(Intervals.of((String)"2011-01-12T00:00:00.000-08:00/2011-01-20T00:00:00.000-08:00"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).build();
        List expectedResults1 = Arrays.asList(new Result(new DateTime((Object)"2011-01-06T00:00:00.000-08:00", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6071L))), new Result(new DateTime((Object)"2011-01-13T00:00:00.000-08:00", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)91L, (Object)"idx", (Object)33382L))));
        List results1 = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query1), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryZeroFilling() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity(Granularities.HOUR).intervals(Collections.singletonList(Intervals.of((String)"2011-04-14T00:00:00.000Z/2011-05-01T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).build();
        ArrayList lotsOfZeroes = Lists.newArrayList();
        Iterable iterable = Granularities.HOUR.getIterable(new Interval((ReadableInstant)DateTimes.of((String)"2011-04-14T01"), (ReadableInstant)DateTimes.of((String)"2011-04-15")));
        for (Interval interval : iterable) {
            lotsOfZeroes.add(new Result(interval.getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"idx", (Object)0L))));
        }
        ArrayList expectedResults1 = Lists.newArrayList((Iterable)Iterables.concat(Collections.singletonList(new Result(DateTimes.of((String)"2011-04-14T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4907L)))), (Iterable)lotsOfZeroes, Collections.singletonList(new Result(DateTimes.of((String)"2011-04-15T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))))));
        List results1 = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query1), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryGranularityNotAlignedWithRollupGranularity() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"PT1H"), DateTimes.utc((long)60000L), DateTimeZone.UTC)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-15T00:00:00.000Z/2012"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-14T23:01Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))));
        List results1 = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query1), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesWithVaryingGranWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).descending(this.descending).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query1), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity("DAY").intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults2 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query2), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesQueryBeyondTimeRangeOfData() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2015-01-01/2015-01-10")))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).build();
        List expectedResults = Collections.emptyList();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOrFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "spot", new String[]{"upfront", "total_market"}).intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithRegexFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)new RegexDimFilter("market", "^.p.*$", null)).intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3783L, (Object)"addRowsIndexConstant", (Object)3795.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3313L, (Object)"addRowsIndexConstant", (Object)3325.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "spot").intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1102L, (Object)"addRowsIndexConstant", (Object)1112.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1120L, (Object)"addRowsIndexConstant", (Object)1130.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "upfront").intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2681L, (Object)"addRowsIndexConstant", (Object)2684.0, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2193L, (Object)"addRowsIndexConstant", (Object)2196.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter3() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "total_market").intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2836L, (Object)"addRowsIndexConstant", (Object)2839.0, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2514L, (Object)"addRowsIndexConstant", (Object)2517.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilterAndOr() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilter() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(135.885094).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(137.885094).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(147.425935).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(149.425935).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOtherMultiDimFilter() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "business", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonDoubleAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(118.57034).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(120.57034).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(112.987027).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(114.987027).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterInOr() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "spot", new String[]{"upfront", "total_market", "billyblank"}).intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithInFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)new InDimFilter("market", Arrays.asList("spot", "upfront", "total_market", "billyblank"), null)).intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDimAndOr() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business", "billyblank"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("bobby", "billy").intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimensionSkipBuckets() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("bobby", "billy").intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)"true")).descending(this.descending).build();
        List expectedResults = Collections.emptyList();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), new HashMap()), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNullFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("bobby", null).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), new HashMap()), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithInvertedFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("bobby", "sally", null))).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), new HashMap()), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "billy").intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "billy", null), new SelectorDimFilter("quality", "business", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregator() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.indexDoubleSum, (Object)QueryRunnerTestHelper.jsIndexSumIfPlacementishA, (Object)QueryRunnerTestHelper.jsPlacementishCount)).descending(this.descending).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(((Interval)QueryRunnerTestHelper.firstToThird.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)12459.361190795898, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)52.0))));
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults((Iterable)expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregatorAndAlsoRegularFilters() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "a").intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.indexDoubleSum, (Object)QueryRunnerTestHelper.jsIndexSumIfPlacementishA, (Object)QueryRunnerTestHelper.jsPlacementishCount)).descending(this.descending).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(((Interval)QueryRunnerTestHelper.firstToThird.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)283.31103515625, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)4.0))));
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults((Iterable)expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithFirstLastAggregator() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.monthGran).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)ImmutableList.of((Object)new DoubleFirstAggregatorFactory("first", "index"), (Object)new DoubleLastAggregatorFactory("last", "index"))).descending(this.descending).build();
        ImmutableList expectedAscendingResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-01-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(100.0).doubleValue(), (Object)"last", (Object)new Float(943.497198).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-02-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(132.123776).doubleValue(), (Object)"last", (Object)new Float(1101.91827).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-03-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(153.059937).doubleValue(), (Object)"last", (Object)new Float(1063.201156).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(135.885094).doubleValue(), (Object)"last", (Object)new Float(780.271977).doubleValue()))));
        ImmutableList expectedDescendingResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(1234.247546).doubleValue(), (Object)"last", (Object)new Float(106.7937).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-03-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(1004.940887).doubleValue(), (Object)"last", (Object)new Float(151.752485).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-02-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(913.561076).doubleValue(), (Object)"last", (Object)new Float(122.258195).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-01-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(800.0).doubleValue(), (Object)"last", (Object)new Float(133.740047).doubleValue()))));
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        if (this.descending) {
            TestHelper.assertExpectedResults(expectedDescendingResults, actualResults);
        } else {
            TestHelper.assertExpectedResults(expectedAscendingResults, actualResults);
        }
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("placementish", "preferred").intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query1), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("placementish", "a").intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("quality", "automotive").intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query1), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr1() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("placementish", "a", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        AndDimFilter andDimFilter2 = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query2), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr2() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("placementish", "a", new String[]{"b"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        AndDimFilter andDimFilter2 = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business"})});
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.firstToThird).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query2), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAgg() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("market", "spot", null))})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)18L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNotNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("abraKaDabra", "Lol", null))})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)0L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("abraKaDabra", null, null))})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggValueNotPresent() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("market", "LolLol", null)))})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggInvertedNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("market", null, null)))})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).descending(this.descending).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithTimeColumn() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.jsCountIfTimeGreaterThan, QueryRunnerTestHelper.__timeLongSum)).granularity(QueryRunnerTestHelper.allGran).descending(this.descending).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)26L, (Object)"ntimestamps", (Object)13.0, (Object)"sumtime", (Object)33843139200000L))));
        List actualResults = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithBoundFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)new AndDimFilter(Arrays.asList(new BoundDimFilter("market", "spa", "spot", Boolean.valueOf(true), null, null, null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("market", "spot", "spotify", null, Boolean.valueOf(true), null, null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("market", "SPOT", "spot", null, null, null, null, StringComparators.LEXICOGRAPHIC)))).intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1102L, (Object)"addRowsIndexConstant", (Object)1112.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1120L, (Object)"addRowsIndexConstant", (Object)1130.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeSeriesWithSelectionFilterLookupExtractionFn() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("spot", "upfront");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, true, null, true, Boolean.valueOf(true));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)new SelectorDimFilter("market", "upfront", (ExtractionFn)lookupExtractionFn)).intervals(QueryRunnerTestHelper.firstToThird).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.addRowsIndexConstant}).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3783L, (Object)"addRowsIndexConstant", (Object)3795.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3313L, (Object)"addRowsIndexConstant", (Object)3325.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        QueryRunner optimizedRunner = toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration(this.runner)));
        List results2 = Sequences.toList((Sequence)new FinalizeResultsQueryRunner(optimizedRunner, (QueryToolChest)toolChest).run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results2);
    }
}

