/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.discovery.DruidLeaderClient;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.java.util.http.client.Request;
import org.apache.hive.druid.io.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.hive.druid.io.druid.query.lookup.LookupConfig;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.io.druid.query.lookup.LookupsState;
import org.apache.hive.druid.io.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.hive.druid.io.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LookupReferencesManagerTest {
    LookupReferencesManager lookupReferencesManager;
    private DruidLeaderClient druidLeaderClient;
    private LookupListeningAnnouncerConfig config;
    private static final String LOOKUP_TIER = "lookupTier";
    LookupExtractorFactory lookupExtractorFactory;
    LookupExtractorFactoryContainer container;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    ObjectMapper mapper = new DefaultObjectMapper();

    @Before
    public void setUp() throws IOException {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.druidLeaderClient = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
        this.config = (LookupListeningAnnouncerConfig)EasyMock.createMock(LookupListeningAnnouncerConfig.class);
        this.lookupExtractorFactory = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true);
        this.container = new LookupExtractorFactoryContainer("v0", this.lookupExtractorFactory);
        this.mapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        String temporaryPath = this.temporaryFolder.newFolder().getAbsolutePath();
        this.lookupReferencesManager = new LookupReferencesManager(new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()), this.mapper, this.druidLeaderClient, this.config, true);
    }

    @Test
    public void testStartStop() throws InterruptedException, IOException {
        this.lookupReferencesManager = new LookupReferencesManager(new LookupConfig(null), this.mapper, this.druidLeaderClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForStartStop", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        Assert.assertFalse((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertNull((Object)this.lookupReferencesManager.mainThread);
        Assert.assertNull(this.lookupReferencesManager.stateRef.get());
        this.lookupReferencesManager.start();
        Assert.assertTrue((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertTrue((boolean)this.lookupReferencesManager.mainThread.isAlive());
        Assert.assertNotNull(this.lookupReferencesManager.stateRef.get());
        this.lookupReferencesManager.stop();
        Assert.assertFalse((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertFalse((boolean)this.lookupReferencesManager.mainThread.isAlive());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetExceptionWhenClosed() {
        this.lookupReferencesManager.get("test");
    }

    @Test(expected=IllegalStateException.class)
    public void testAddExceptionWhenClosed() {
        this.lookupReferencesManager.add("test", (LookupExtractorFactoryContainer)EasyMock.createMock(LookupExtractorFactoryContainer.class));
    }

    @Test(expected=IllegalStateException.class)
    public void testRemoveExceptionWhenClosed() {
        this.lookupReferencesManager.remove("test");
    }

    @Test(expected=IllegalStateException.class)
    public void testGetAllLookupsStateExceptionWhenClosed() {
        this.lookupReferencesManager.getAllLookupsState();
    }

    @Test
    public void testAddGetRemove() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.close()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForAddGetRemove", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertNull((Object)this.lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        this.lookupReferencesManager.add("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals((Object)testContainer, (Object)this.lookupReferencesManager.get("test"));
        this.lookupReferencesManager.remove("test");
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertNull((Object)this.lookupReferencesManager.get("test"));
    }

    @Test
    public void testCloseIsCalledAfterStopping() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createStrictMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.close()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForCloseIsCalledAfterStopping", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMock", new LookupExtractorFactoryContainer("0", lookupExtractorFactory));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.stop();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory});
    }

    @Test
    public void testCloseIsCalledAfterRemove() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createStrictMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.close()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForCloseIsCalledAfterRemove", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMock", new LookupExtractorFactoryContainer("0", lookupExtractorFactory));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.remove("testMock");
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory});
    }

    @Test
    public void testGetNotThere() throws Exception {
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForGetNotThere", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertNull((Object)this.lookupReferencesManager.get("notThere"));
    }

    @Test
    public void testUpdateWithHigherVersion() throws Exception {
        LookupExtractorFactory lookupExtractorFactory1 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory1.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory1.close()).andReturn((Object)true).once();
        LookupExtractorFactory lookupExtractorFactory2 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory2.start()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForUpdateWithHigherVersion", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("1", lookupExtractorFactory1));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("2", lookupExtractorFactory2));
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
    }

    @Test
    public void testUpdateWithLowerVersion() throws Exception {
        LookupExtractorFactory lookupExtractorFactory1 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory1.start()).andReturn((Object)true).once();
        LookupExtractorFactory lookupExtractorFactory2 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForUpdateWithLowerVersion", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("1", lookupExtractorFactory1));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("0", lookupExtractorFactory2));
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
    }

    @Test
    public void testRemoveNonExisting() throws Exception {
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForRemoveNonExisting", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.remove("test");
        this.lookupReferencesManager.handlePendingNotices();
    }

    @Test
    public void testGetAllLookupsState() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        LookupExtractorFactoryContainer container3 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key3", (Object)"value3"), true));
        HashMap lookupMap = new HashMap();
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("one", container1);
        this.lookupReferencesManager.add("two", container2);
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.remove("one");
        this.lookupReferencesManager.add("three", container3);
        LookupsState state = this.lookupReferencesManager.getAllLookupsState();
        Assert.assertEquals((long)2L, (long)state.getCurrent().size());
        Assert.assertEquals((Object)container1, state.getCurrent().get("one"));
        Assert.assertEquals((Object)container2, state.getCurrent().get("two"));
        Assert.assertEquals((long)1L, (long)state.getToLoad().size());
        Assert.assertEquals((Object)container3, state.getToLoad().get("three"));
        Assert.assertEquals((long)1L, (long)state.getToDrop().size());
        Assert.assertTrue((boolean)state.getToDrop().contains("one"));
    }

    @Test(timeout=20000L)
    public void testRealModeWithMainThread() throws Exception {
        LookupReferencesManager lookupReferencesManager = new LookupReferencesManager(new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()), this.mapper, this.druidLeaderClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForRealModeWithMainThread", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        lookupReferencesManager.start();
        Assert.assertTrue((boolean)lookupReferencesManager.mainThread.isAlive());
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.close()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        Assert.assertNull((Object)lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        lookupReferencesManager.add("test", testContainer);
        while (!testContainer.equals((Object)lookupReferencesManager.get("test"))) {
            Thread.sleep(100L);
        }
        lookupReferencesManager.remove("test");
        while (lookupReferencesManager.get("test") != null) {
            Thread.sleep(100L);
        }
        lookupReferencesManager.stop();
        Assert.assertFalse((boolean)lookupReferencesManager.mainThread.isAlive());
    }

    @Test
    public void testCoordinatorLookupSync() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        LookupExtractorFactoryContainer container3 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key3", (Object)"value3"), true));
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testLookup1", container1);
        lookupMap.put("testLookup2", container2);
        lookupMap.put("testLookup3", container3);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals((Object)container1, (Object)this.lookupReferencesManager.get("testLookup1"));
        Assert.assertEquals((Object)container2, (Object)this.lookupReferencesManager.get("testLookup2"));
        Assert.assertEquals((Object)container3, (Object)this.lookupReferencesManager.get("testLookup3"));
    }

    @Test
    public void testLoadLookupOnCoordinatorFailure() throws Exception {
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForLoadLookupOnCoordinatorFailure", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request).anyTimes();
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.NOT_FOUND, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andThrow((Throwable)new IllegalStateException()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMockForLoadLookupOnCoordinatorFailure", this.container);
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.stop();
        this.lookupReferencesManager = new LookupReferencesManager(new LookupConfig(this.lookupReferencesManager.lookupSnapshotTaker.getPersistFile(LOOKUP_TIER).getParent()), this.mapper, this.druidLeaderClient, this.config, true);
        EasyMock.reset((Object[])new Object[]{this.config});
        EasyMock.reset((Object[])new Object[]{this.druidLeaderClient});
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andThrow((Throwable)new IllegalStateException()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals((Object)this.container, (Object)this.lookupReferencesManager.get("testMockForLoadLookupOnCoordinatorFailure"));
    }

    @Test
    public void testDisableLookupSync() throws Exception {
        LookupReferencesManager lookupReferencesManager = new LookupReferencesManager(new LookupConfig(null), this.mapper, this.druidLeaderClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForDisableLookupSync", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/lookupTier?detailed=true")).andReturn((Object)request);
        FullResponseHolder responseHolder = new FullResponseHolder(HttpResponseStatus.OK, (HttpResponse)EasyMock.createNiceMock(HttpResponse.class), new StringBuilder().append(strResult));
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        lookupReferencesManager.start();
        Assert.assertNull((Object)lookupReferencesManager.get("testMockForDisableLookupSync"));
    }
}

