/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.orderby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.groupby.orderby.TopNSequence;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopNSequenceTest {
    private static final Ordering<String> ASC = Ordering.natural();
    private static final Ordering<String> DESC = Ordering.natural().reverse();
    private static final List<String> EMPTY = Collections.EMPTY_LIST;
    private static final List<String> SINGLE = Lists.newArrayList((Object[])new String[]{"a"});
    private static final List<String> RAW_ASC = Lists.newArrayList((Iterable)Splitter.fixedLength((int)1).split((CharSequence)"abcdefghijk"));
    private static final List<String> RAW_DESC = Lists.newArrayList((Iterable)Splitter.fixedLength((int)1).split((CharSequence)"kjihgfedcba"));
    private Ordering<String> ordering;
    private List<String> rawInput;
    private int limit;

    @Parameterized.Parameters
    public static Collection<Object[]> makeTestData() {
        Object[][] data = new Object[][]{{ASC, RAW_ASC, RAW_ASC.size() - 2}, {ASC, RAW_ASC, RAW_ASC.size()}, {ASC, RAW_ASC, RAW_ASC.size() + 2}, {ASC, RAW_ASC, 0}, {ASC, SINGLE, 0}, {ASC, SINGLE, 1}, {ASC, SINGLE, 2}, {ASC, SINGLE, 3}, {ASC, EMPTY, 0}, {ASC, EMPTY, 1}, {DESC, RAW_DESC, RAW_DESC.size() - 2}, {DESC, RAW_DESC, RAW_DESC.size()}, {DESC, RAW_DESC, RAW_DESC.size() + 2}, {DESC, RAW_DESC, 0}, {DESC, RAW_DESC, 0}, {DESC, SINGLE, 1}, {DESC, SINGLE, 2}, {DESC, SINGLE, 3}, {DESC, EMPTY, 0}, {DESC, EMPTY, 1}};
        return Arrays.asList(data);
    }

    public TopNSequenceTest(Ordering<String> ordering, List<String> rawInput, int limit) {
        this.ordering = ordering;
        this.rawInput = rawInput;
        this.limit = limit;
    }

    @Test
    public void testOrderByWithLimit() {
        List<String> expected = this.rawInput.subList(0, Math.min(this.limit, this.rawInput.size()));
        ArrayList inputs = Lists.newArrayList(this.rawInput);
        Collections.shuffle(inputs, new Random(2L));
        TopNSequence result = new TopNSequence(Sequences.simple((Iterable)inputs), this.ordering, this.limit);
        Assert.assertEquals(expected, (Object)Sequences.toList((Sequence)result, (List)Lists.newArrayList()));
    }
}

