/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.orderby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class DefaultLimitSpecTest {
    private final List<Row> testRowsList = ImmutableList.of((Object)this.createRow("2011-04-01", "k1", 10.0, "k2", 1L, "k3", 2L), (Object)this.createRow("2011-04-01", "k1", 20.0, "k2", 3L, "k3", 1L), (Object)this.createRow("2011-04-01", "k1", 9.0, "k2", 2L, "k3", 3L));
    private final Sequence<Row> testRowsSequence = Sequences.simple(this.testRowsList);

    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        String json = "{\"type\": \"default\"}";
        DefaultLimitSpec spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, DefaultLimitSpec.class)), DefaultLimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec(null, null), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[{\"dimension\":\"d\",\"direction\":\"DESCENDING\", \"dimensionOrder\":\"numeric\"}],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, DefaultLimitSpec.class)), DefaultLimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(10)), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[{\"dimension\":\"d\",\"direction\":\"DES\", \"dimensionOrder\":\"numeric\"}],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, DefaultLimitSpec.class)), DefaultLimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(10)), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[{\"dimension\":\"d\"}],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, DefaultLimitSpec.class)), DefaultLimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(10)), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[\"d\"],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, DefaultLimitSpec.class)), DefaultLimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(10)), (Object)spec);
    }

    @Test
    public void testBuildSimple() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(2));
        Function limitFn = limitSpec.build((List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Granularities.NONE, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(0), (Object)this.testRowsList.get(1)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
    }

    @Test
    public void testWithAllGranularity() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(2));
        Function limitFn = limitSpec.build((List)ImmutableList.of((Object)new DefaultDimensionSpec("k1", "k1", ValueType.DOUBLE)), (List)ImmutableList.of(), (List)ImmutableList.of(), Granularities.ALL, true);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(0), (Object)this.testRowsList.get(1)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
    }

    @Test
    public void testWithSortByDimsFirst() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(2));
        Function limitFn = limitSpec.build((List)ImmutableList.of((Object)new DefaultDimensionSpec("k1", "k1", ValueType.DOUBLE)), (List)ImmutableList.of(), (List)ImmutableList.of(), Granularities.NONE, true);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(0)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
    }

    @Test
    public void testSortDimensionDescending() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(2));
        Function limitFn = limitSpec.build((List)ImmutableList.of((Object)new DefaultDimensionSpec("k1", "k1")), (List)ImmutableList.of(), (List)ImmutableList.of(), Granularities.NONE, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(1)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
    }

    @Test
    public void testBuildWithExplicitOrder() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(2));
        Function limitFn = limitSpec.build((List)ImmutableList.of((Object)new DefaultDimensionSpec("k1", "k1")), (List)ImmutableList.of((Object)new LongSumAggregatorFactory("k2", "k2")), (List)ImmutableList.of((Object)new ConstantPostAggregator("k3", (Number)1L)), Granularities.NONE, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(0), (Object)this.testRowsList.get(1)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
        limitFn = limitSpec.build((List)ImmutableList.of((Object)new DefaultDimensionSpec("k1", "k1")), (List)ImmutableList.of((Object)new LongSumAggregatorFactory("k1", "k1")), (List)ImmutableList.of((Object)new ConstantPostAggregator("k3", (Number)1L)), Granularities.NONE, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(0)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
        limitFn = limitSpec.build((List)ImmutableList.of((Object)new DefaultDimensionSpec("k1", "k1")), (List)ImmutableList.of((Object)new LongSumAggregatorFactory("k2", "k2")), (List)ImmutableList.of((Object)new ArithmeticPostAggregator("k1", "+", (List)ImmutableList.of((Object)new ConstantPostAggregator("x", (Number)1), (Object)new ConstantPostAggregator("y", (Number)1)))), Granularities.NONE, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(0)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
        limitFn = limitSpec.build((List)ImmutableList.of((Object)new DefaultDimensionSpec("k1", "k1")), (List)ImmutableList.of((Object)new LongSumAggregatorFactory("k2", "k2")), (List)ImmutableList.of((Object)new ExpressionPostAggregator("k1", "1 + 1", null, TestExprMacroTable.INSTANCE)), Granularities.NONE, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(0)), (Object)Sequences.toList((Sequence)((Sequence)limitFn.apply(this.testRowsSequence)), new ArrayList()));
    }

    private Row createRow(String timestamp, Object ... vals) {
        Preconditions.checkArgument((vals.length % 2 == 0 ? 1 : 0) != 0);
        HashMap theVals = Maps.newHashMap();
        for (int i = 0; i < vals.length; i += 2) {
            theVals.put(vals[i].toString(), vals[i + 1]);
        }
        return new MapBasedRow(DateTimes.of((String)timestamp), (Map)theVals);
    }
}

