/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonFactory;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.DefaultBlockingPool;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.BySegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryEngine;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV1;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV2;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByLimitPushDownInsufficientBufferTest {
    private static final IndexMergerV9 INDEX_MERGER_V9;
    private static final IndexIO INDEX_IO;
    public static final ObjectMapper JSON_MAPPER;
    private File tmpDir;
    private QueryRunnerFactory<Row, GroupByQuery> groupByFactory;
    private QueryRunnerFactory<Row, GroupByQuery> tooSmallGroupByFactory;
    private List<IncrementalIndex> incrementalIndices = Lists.newArrayList();
    private List<QueryableIndex> groupByIndices = Lists.newArrayList();
    private ExecutorService executorService;
    public static final QueryWatcher NOOP_QUERYWATCHER;

    private IncrementalIndex makeIncIndex(boolean withRollup) {
        return new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dimA"), new LongDimensionSchema("metA")), null, null)).withRollup(withRollup).build()).setReportParseExceptions(false).setConcurrentEventAdd(true).setMaxRowCount(1000).buildOnheap();
    }

    @Before
    public void setup() throws Exception {
        this.tmpDir = Files.createTempDir();
        List<String> dimNames = Arrays.asList("dimA", "metA");
        IncrementalIndex indexA = this.makeIncIndex(false);
        this.incrementalIndices.add(indexA);
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("dimA", "hello");
        event.put("metA", 100);
        MapBasedInputRow row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 95);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "world");
        event.put("metA", 75);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "fubaz");
        event.put("metA", 75);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "zortaxx");
        event.put("metA", 999);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "blarg");
        event.put("metA", 125);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "blerg");
        event.put("metA", 130);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        File fileA = INDEX_MERGER_V9.persist(indexA, new File(this.tmpDir, "A"), new IndexSpec(), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        QueryableIndex qindexA = INDEX_IO.loadIndex(fileA);
        IncrementalIndex indexB = this.makeIncIndex(false);
        this.incrementalIndices.add(indexB);
        event = new HashMap();
        event.put("dimA", "foo");
        event.put("metA", 200);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "world");
        event.put("metA", 75);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 95);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "zebra");
        event.put("metA", 180);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "blorg");
        event.put("metA", 120);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        File fileB = INDEX_MERGER_V9.persist(indexB, new File(this.tmpDir, "B"), new IndexSpec(), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        QueryableIndex qindexB = INDEX_IO.loadIndex(fileB);
        this.groupByIndices = Arrays.asList(qindexA, qindexB);
        this.setupGroupByFactory();
    }

    private void setupGroupByFactory() {
        this.executorService = Execs.multiThreaded((int)3, (String)"GroupByThreadPool[%d]");
        StupidPool bufferPool = new StupidPool("GroupByBenchmark-computeBufferPool", (Supplier)new OffheapBufferGenerator("compute", 10000000), 0, Integer.MAX_VALUE);
        DefaultBlockingPool mergePool = new DefaultBlockingPool((Supplier)new OffheapBufferGenerator("merge", 10000000), 2);
        DefaultBlockingPool tooSmallMergePool = new DefaultBlockingPool((Supplier)new OffheapBufferGenerator("merge", 255), 2);
        GroupByQueryConfig config = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getBufferGrouperInitialBuckets() {
                return -1;
            }

            public long getMaxOnDiskStorage() {
                return 1000000000L;
            }
        };
        config.setSingleThreaded(false);
        config.setMaxIntermediateRows(Integer.MAX_VALUE);
        config.setMaxResults(Integer.MAX_VALUE);
        DruidProcessingConfig druidProcessingConfig = new DruidProcessingConfig(){

            public int getNumThreads() {
                return 2;
            }

            public String getFormatString() {
                return null;
            }
        };
        DruidProcessingConfig tooSmallDruidProcessingConfig = new DruidProcessingConfig(){

            public int intermediateComputeSizeBytes() {
                return 255;
            }

            public int getNumThreads() {
                return 2;
            }

            public String getFormatString() {
                return null;
            }
        };
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, (NonBlockingPool)bufferPool), NOOP_QUERYWATCHER, (NonBlockingPool)bufferPool), new GroupByStrategyV2(druidProcessingConfig, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)mergePool, new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER));
        GroupByStrategySelector tooSmallStrategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, (NonBlockingPool)bufferPool), NOOP_QUERYWATCHER, (NonBlockingPool)bufferPool), new GroupByStrategyV2(tooSmallDruidProcessingConfig, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)tooSmallMergePool, new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER));
        this.groupByFactory = new GroupByQueryRunnerFactory(strategySelector, new GroupByQueryQueryToolChest(strategySelector, GroupByLimitPushDownInsufficientBufferTest.NoopIntervalChunkingQueryRunnerDecorator()));
        this.tooSmallGroupByFactory = new GroupByQueryRunnerFactory(tooSmallStrategySelector, new GroupByQueryQueryToolChest(tooSmallStrategySelector, GroupByLimitPushDownInsufficientBufferTest.NoopIntervalChunkingQueryRunnerDecorator()));
    }

    @After
    public void tearDown() throws Exception {
        for (IncrementalIndex incrementalIndex : this.incrementalIndices) {
            incrementalIndex.close();
        }
        for (QueryableIndex queryableIndex : this.groupByIndices) {
            queryableIndex.close();
        }
        if (this.tmpDir != null) {
            FileUtils.deleteDirectory((File)this.tmpDir);
        }
    }

    @Test
    public void testPartialLimitPushDownMerge() throws Exception {
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners(this.executorService, this.getRunner1())), toolChest);
        FinalizeResultsQueryRunner theRunner2 = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.tooSmallGroupByFactory.mergeRunners(this.executorService, this.getRunner2())), toolChest);
        FinalizeResultsQueryRunner theRunner3 = new FinalizeResultsQueryRunner(toolChest.mergeResults((QueryRunner)new QueryRunner<Row>((QueryRunner)theRunner, (QueryRunner)theRunner2){
            final /* synthetic */ QueryRunner val$theRunner;
            final /* synthetic */ QueryRunner val$theRunner2;
            {
                this.val$theRunner = queryRunner;
                this.val$theRunner2 = queryRunner2;
            }

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)this.val$theRunner.run(queryPlus, responseContext), (Object)this.val$theRunner2.run(queryPlus, responseContext))).flatMerge(Function.identity(), queryPlus.getQuery().getResultOrdering());
            }
        }), toolChest);
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)0L, (long)1000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("dimA", null)})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("metA", "metA"))).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("dimA", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(3))).setGranularity(Granularities.ALL).build();
        Sequence queryResult = theRunner3.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap());
        List results = Sequences.toList((Sequence)queryResult, (List)Lists.newArrayList());
        Row expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "dimA", "zortaxx", "metA", 999L);
        Row expectedRow1 = GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "dimA", "zebra", "metA", 180L);
        Row expectedRow2 = GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "dimA", "world", "metA", 150L);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
        Assert.assertEquals((Object)expectedRow1, results.get(1));
        Assert.assertEquals((Object)expectedRow2, results.get(2));
    }

    @Test
    public void testPartialLimitPushDownMergeForceAggs() throws Exception {
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners(this.executorService, this.getRunner1())), toolChest);
        FinalizeResultsQueryRunner theRunner2 = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.tooSmallGroupByFactory.mergeRunners(this.executorService, this.getRunner2())), toolChest);
        FinalizeResultsQueryRunner theRunner3 = new FinalizeResultsQueryRunner(toolChest.mergeResults((QueryRunner)new QueryRunner<Row>((QueryRunner)theRunner, (QueryRunner)theRunner2){
            final /* synthetic */ QueryRunner val$theRunner;
            final /* synthetic */ QueryRunner val$theRunner2;
            {
                this.val$theRunner = queryRunner;
                this.val$theRunner2 = queryRunner2;
            }

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)this.val$theRunner.run(queryPlus, responseContext), (Object)this.val$theRunner2.run(queryPlus, responseContext))).flatMerge(Function.identity(), queryPlus.getQuery().getResultOrdering());
            }
        }), toolChest);
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)0L, (long)1000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("dimA", null)})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("metA", "metA"))).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("metA", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(3))).setGranularity(Granularities.ALL).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).build();
        Sequence queryResult = theRunner3.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap());
        List results = Sequences.toList((Sequence)queryResult, (List)Lists.newArrayList());
        Row expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "dimA", "zortaxx", "metA", 999L);
        Row expectedRow1 = GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "dimA", "foo", "metA", 200L);
        Row expectedRow2 = GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "dimA", "mango", "metA", 190L);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
        Assert.assertEquals((Object)expectedRow1, results.get(1));
        Assert.assertEquals((Object)expectedRow2, results.get(2));
    }

    private List<QueryRunner<Row>> getRunner1() {
        ArrayList runners = Lists.newArrayList();
        QueryableIndex index = this.groupByIndices.get(0);
        QueryRunner<Row> runner = GroupByLimitPushDownInsufficientBufferTest.makeQueryRunner(this.groupByFactory, index.toString(), (Segment)new QueryableIndexSegment(index.toString(), index));
        runners.add(this.groupByFactory.getToolchest().preMergeQueryDecoration(runner));
        return runners;
    }

    private List<QueryRunner<Row>> getRunner2() {
        ArrayList runners = Lists.newArrayList();
        QueryableIndex index2 = this.groupByIndices.get(1);
        QueryRunner<Row> tooSmallRunner = GroupByLimitPushDownInsufficientBufferTest.makeQueryRunner(this.tooSmallGroupByFactory, index2.toString(), (Segment)new QueryableIndexSegment(index2.toString(), index2));
        runners.add(this.tooSmallGroupByFactory.getToolchest().preMergeQueryDecoration(tooSmallRunner));
        return runners;
    }

    public static <T, QueryType extends Query<T>> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, QueryType> factory, String segmentId, Segment adapter) {
        return new FinalizeResultsQueryRunner((QueryRunner)new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), factory.createRunner(adapter)), factory.getToolchest());
    }

    public static IntervalChunkingQueryRunnerDecorator NoopIntervalChunkingQueryRunnerDecorator() {
        return new IntervalChunkingQueryRunnerDecorator(null, null, null){

            public <T> QueryRunner<T> decorate(final QueryRunner<T> delegate, QueryToolChest<T, ? extends Query<T>> toolChest) {
                return new QueryRunner<T>(){

                    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
                        return delegate.run(queryPlus, responseContext);
                    }
                };
            }
        };
    }

    static {
        JSON_MAPPER = new DefaultObjectMapper();
        JSON_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)ExprMacroTable.nil()));
        INDEX_IO = new IndexIO(JSON_MAPPER, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        NOOP_QUERYWATCHER = new QueryWatcher(){

            public void registerQuery(Query query, ListenableFuture future) {
            }
        };
    }

    private static class OffheapBufferGenerator
    implements Supplier<ByteBuffer> {
        private static final Logger log = new Logger(OffheapBufferGenerator.class);
        private final String description;
        private final int computationBufferSize;
        private final AtomicLong count = new AtomicLong(0L);

        public OffheapBufferGenerator(String description, int computationBufferSize) {
            this.description = description;
            this.computationBufferSize = computationBufferSize;
        }

        public ByteBuffer get() {
            log.info("Allocating new %s buffer[%,d] of size[%,d]", new Object[]{this.description, this.count.getAndIncrement(), this.computationBufferSize});
            return ByteBuffer.allocateDirect(this.computationBufferSize);
        }
    }
}

