/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.search.SearchQueryConfig;
import org.apache.hive.druid.io.druid.query.search.SearchQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.search.SearchQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.search.SearchStrategySelector;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryConfig;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.hive.druid.io.druid.segment.Segment;

public class TestQueryRunners {
    public static final NonBlockingPool<ByteBuffer> pool = new StupidPool("TestQueryRunners-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

        public ByteBuffer get() {
            return ByteBuffer.allocate(0xA00000);
        }
    });
    public static final TopNQueryConfig topNConfig = new TopNQueryConfig();

    public static NonBlockingPool<ByteBuffer> getPool() {
        return pool;
    }

    public static <T> QueryRunner<T> makeTopNQueryRunner(Segment adapter) {
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, new TopNQueryQueryToolChest(topNConfig, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeTimeSeriesQueryRunner(Segment adapter) {
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeSearchQueryRunner(Segment adapter) {
        SearchQueryConfig config = new SearchQueryConfig();
        SearchQueryRunnerFactory factory = new SearchQueryRunnerFactory(new SearchStrategySelector(Suppliers.ofInstance((Object)config)), new SearchQueryQueryToolChest(config, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeTimeBoundaryQueryRunner(Segment adapter) {
        TimeBoundaryQueryRunnerFactory factory = new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }
}

