/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.io.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.io.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.IndexBuilder;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SchemaEvolutionTest {
    private static final String DATA_SOURCE = "foo";
    private static final String TIMESTAMP_COLUMN = "t";
    private static final double THIRTY_ONE_POINT_ONE = 31.1;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private QueryableIndex index1 = null;
    private QueryableIndex index2 = null;
    private QueryableIndex index3 = null;
    private QueryableIndex index4 = null;

    public static List<Result<TimeseriesResultValue>> timeseriesResult(Map<String, ?> map) {
        return ImmutableList.of((Object)new Result(DateTimes.of((String)"2000"), (Object)new TimeseriesResultValue(map)));
    }

    public static List<InputRow> inputRowsWithDimensions(List<String> dimensions) {
        MapInputRowParser parser = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec(TIMESTAMP_COLUMN, "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(dimensions), dimensions.isEmpty() ? ImmutableList.of((Object)TIMESTAMP_COLUMN, (Object)"c1", (Object)"c2") : null, null)));
        return ImmutableList.of(parser.parseBatch((Map)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)"2000-01-01", (Object)"c1", (Object)"9", (Object)"c2", (Object)ImmutableList.of((Object)"a"))).get(0), parser.parseBatch((Map)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)"2000-01-02", (Object)"c1", (Object)"10.1", (Object)"c2", (Object)ImmutableList.of())).get(0), parser.parseBatch((Map)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)"2000-01-03", (Object)"c1", (Object)"2", (Object)"c2", (Object)ImmutableList.of((Object)""))).get(0), parser.parseBatch((Map)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)"2001-01-01", (Object)"c1", (Object)"1", (Object)"c2", (Object)ImmutableList.of((Object)"a", (Object)"c"))).get(0), parser.parseBatch((Map)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)"2001-01-02", (Object)"c1", (Object)"4", (Object)"c2", (Object)ImmutableList.of((Object)"abc"))).get(0), parser.parseBatch((Map)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)"2001-01-03", (Object)"c1", (Object)"5")).get(0));
    }

    public static <T, QueryType extends Query<T>> List<T> runQuery(QueryType query, final QueryRunnerFactory<T, QueryType> factory, List<QueryableIndex> indexes) {
        Sequence results = new FinalizeResultsQueryRunner(factory.getToolchest().mergeResults(factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)FunctionalIterable.create(indexes).transform(new Function<QueryableIndex, QueryRunner<T>>(){

            public QueryRunner<T> apply(QueryableIndex index) {
                return factory.createRunner((Segment)new QueryableIndexSegment("xxx", index));
            }
        }))), factory.getToolchest()).run(QueryPlus.wrap(query), (Map)Maps.newHashMap());
        return Sequences.toList((Sequence)results, (List)Lists.newArrayList());
    }

    @Before
    public void setUp() throws IOException {
        this.index1 = IndexBuilder.create().tmpDir(this.temporaryFolder.newFolder()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withRollup(false).build()).rows(SchemaEvolutionTest.inputRowsWithDimensions((List<String>)ImmutableList.of((Object)"c1"))).buildMMappedIndex();
        this.index2 = IndexBuilder.create().tmpDir(this.temporaryFolder.newFolder()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new LongSumAggregatorFactory("c1", "c1"), new HyperUniquesAggregatorFactory("uniques", "c2")}).withRollup(false).build()).rows(SchemaEvolutionTest.inputRowsWithDimensions((List<String>)ImmutableList.of((Object)"c2"))).buildMMappedIndex();
        this.index3 = IndexBuilder.create().tmpDir(this.temporaryFolder.newFolder()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("c1", "c1"), new HyperUniquesAggregatorFactory("uniques", "c2")}).withRollup(false).build()).rows(SchemaEvolutionTest.inputRowsWithDimensions((List<String>)ImmutableList.of((Object)"c2"))).buildMMappedIndex();
        this.index4 = IndexBuilder.create().tmpDir(this.temporaryFolder.newFolder()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new HyperUniquesAggregatorFactory("c2", "c2")}).withRollup(false).build()).rows(SchemaEvolutionTest.inputRowsWithDimensions((List<String>)ImmutableList.of())).buildMMappedIndex();
        if (this.index4.getAvailableDimensions().size() != 0) {
            throw new ISE("WTF?! Expected no dimensions in index4", new Object[0]);
        }
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.index1, (boolean)false);
        Closeables.close((Closeable)this.index2, (boolean)false);
        Closeables.close((Closeable)this.index3, (boolean)false);
        Closeables.close((Closeable)this.index4, (boolean)false);
    }

    @Test
    public void testHyperUniqueEvolutionTimeseries() {
        TimeseriesQueryRunnerFactory factory = QueryRunnerTestHelper.newTimeseriesQueryRunnerFactory();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals("1000/3000").aggregators((List)ImmutableList.of((Object)new HyperUniquesAggregatorFactory("uniques", "uniques"))).build();
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"uniques", (Object)0)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index1)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"uniques", (Object)4.003911343725148)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index1, (Object)this.index2, (Object)this.index3)));
    }

    @Test
    public void testNumericEvolutionTimeseriesAggregation() {
        TimeseriesQueryRunnerFactory factory = QueryRunnerTestHelper.newTimeseriesQueryRunnerFactory();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals("1000/3000").aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("a", "c1"), (Object)new DoubleSumAggregatorFactory("b", "c1"), (Object)new LongSumAggregatorFactory("c", null, "c1 * 1", TestExprMacroTable.INSTANCE), (Object)new DoubleSumAggregatorFactory("d", null, "c1 * 1", TestExprMacroTable.INSTANCE))).build();
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)0L, (Object)"b", (Object)0.0, (Object)"c", (Object)31L, (Object)"d", (Object)31.1)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index1)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)31L, (Object)"b", (Object)31.0, (Object)"c", (Object)31L, (Object)"d", (Object)31.0)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index2)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)31L, (Object)"b", (Object)31.1, (Object)"c", (Object)31L, (Object)"d", (Object)31.1)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index3)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)0L, (Object)"b", (Object)0.0, (Object)"c", (Object)0L, (Object)"d", (Object)0.0)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index4)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)62L, (Object)"b", (Object)62.1, (Object)"c", (Object)93L, (Object)"d", (Object)93.2)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index1, (Object)this.index2, (Object)this.index3, (Object)this.index4)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)62L, (Object)"b", (Object)62.1, (Object)"c", (Object)62L, (Object)"d", (Object)62.1)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index2, (Object)this.index3, (Object)this.index4)));
    }

    @Test
    public void testNumericEvolutionFiltering() {
        TimeseriesQueryRunnerFactory factory = QueryRunnerTestHelper.newTimeseriesQueryRunnerFactory();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals("1000/3000").filters((DimFilter)new BoundDimFilter("c1", "9", "11", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC)).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("a", "c1"), (Object)new DoubleSumAggregatorFactory("b", "c1"), (Object)new CountAggregatorFactory("c"))).build();
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)0L, (Object)"b", (Object)0.0, (Object)"c", (Object)2L)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index1)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)19L, (Object)"b", (Object)19.0, (Object)"c", (Object)2L)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index2)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)19L, (Object)"b", (Object)19.1, (Object)"c", (Object)2L)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index3)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)0L, (Object)"b", (Object)0.0, (Object)"c", (Object)0L)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index4)));
        Assert.assertEquals(SchemaEvolutionTest.timeseriesResult(ImmutableMap.of((Object)"a", (Object)38L, (Object)"b", (Object)38.1, (Object)"c", (Object)6L)), SchemaEvolutionTest.runQuery(query, factory, (List<QueryableIndex>)ImmutableList.of((Object)this.index1, (Object)this.index2, (Object)this.index3, (Object)this.index4)));
    }
}

