/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.query.Queries;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.junit.Assert;
import org.junit.Test;

public class QueriesTest {
    @Test
    public void testVerifyAggregations() throws Exception {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<PostAggregator> postAggs = Arrays.asList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccured = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertFalse((boolean)exceptionOccured);
    }

    @Test
    public void testVerifyAggregationsMissingVal() throws Exception {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<PostAggregator> postAggs = Arrays.asList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx2"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccured = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testVerifyAggregationsMultiLevel() throws Exception {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<PostAggregator> postAggs = Arrays.asList(new ArithmeticPostAggregator("divideStuff", "/", Arrays.asList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx"), new ConstantPostAggregator("const", (Number)1))), new ArithmeticPostAggregator("subtractStuff", "-", Arrays.asList(new FieldAccessPostAggregator("rev", "rev"), new ConstantPostAggregator("const", (Number)1))))), new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("divideStuff", "divideStuff"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccured = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertFalse((boolean)exceptionOccured);
    }

    @Test
    public void testVerifyAggregationsMultiLevelMissingVal() throws Exception {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<PostAggregator> postAggs = Arrays.asList(new ArithmeticPostAggregator("divideStuff", "/", Arrays.asList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx"), new ConstantPostAggregator("const", (Number)1))), new ArithmeticPostAggregator("subtractStuff", "-", Arrays.asList(new FieldAccessPostAggregator("rev", "rev2"), new ConstantPostAggregator("const", (Number)1))))), new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("divideStuff", "divideStuff"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccured = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

