/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.sql.SQLException;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.NoopMetadataStorageProvider;
import org.apache.hive.druid.io.druid.metadata.storage.derby.DerbyConnector;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public class TestDerbyConnector
extends DerbyConnector {
    private final String jdbcUri;

    public TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables) {
        this(config, dbTables, "jdbc:derby:memory:druidTest" + TestDerbyConnector.dbSafeUUID());
    }

    protected TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, String jdbcUri) {
        super(new NoopMetadataStorageProvider().get(), config, dbTables, new DBI(jdbcUri + ";create=true"));
        this.jdbcUri = jdbcUri;
    }

    public void tearDown() {
        try {
            new DBI(this.jdbcUri + ";drop=true").open().close();
        }
        catch (UnableToObtainConnectionException e) {
            SQLException cause = (SQLException)e.getCause();
            Assert.assertEquals((String)StringUtils.format((String)"Derby not shutdown: [%s]", (Object[])new Object[]{cause.toString()}), (Object)"08006", (Object)cause.getSQLState());
        }
    }

    public static String dbSafeUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getJdbcUri() {
        return this.jdbcUri;
    }

    public static class DerbyConnectorRule
    extends ExternalResource {
        private TestDerbyConnector connector;
        private final Supplier<MetadataStorageTablesConfig> dbTables;
        private final MetadataStorageConnectorConfig connectorConfig;

        public DerbyConnectorRule() {
            this("druidTest" + TestDerbyConnector.dbSafeUUID());
        }

        private DerbyConnectorRule(String defaultBase) {
            this((Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)MetadataStorageTablesConfig.fromBase((String)defaultBase)));
        }

        public DerbyConnectorRule(Supplier<MetadataStorageTablesConfig> dbTables) {
            this.dbTables = dbTables;
            this.connectorConfig = new MetadataStorageConnectorConfig(){

                public String getConnectURI() {
                    return connector.getJdbcUri();
                }
            };
        }

        protected void before() throws Throwable {
            this.connector = new TestDerbyConnector((Supplier<MetadataStorageConnectorConfig>)Suppliers.ofInstance((Object)this.connectorConfig), this.dbTables);
            this.connector.getDBI().open().close();
        }

        protected void after() {
            this.connector.tearDown();
        }

        public TestDerbyConnector getConnector() {
            return this.connector;
        }

        public MetadataStorageConnectorConfig getMetadataConnectorConfig() {
            return this.connectorConfig;
        }

        public Supplier<MetadataStorageTablesConfig> metadataTablesConfigSupplier() {
            return this.dbTables;
        }
    }
}

