/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.http.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClientConfig;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClientInit;
import org.apache.hive.druid.io.druid.java.util.http.client.Request;
import org.apache.hive.druid.io.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelException;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FriendlyServersTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFriendlyHttpServer() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final ServerSocket serverSocket = new ServerSocket(0);
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        Throwable throwable = null;
                        try {
                            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));
                            Throwable throwable2 = null;
                            try {
                                OutputStream out = clientSocket.getOutputStream();
                                Throwable throwable3 = null;
                                try {
                                    while (!in.readLine().equals("")) {
                                    }
                                    out.write("HTTP/1.1 200 OK\r\nContent-Length: 6\r\n\r\nhello!".getBytes(Charsets.UTF_8));
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (out == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    out.close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (in == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                in.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (clientSocket == null) continue;
                            if (throwable != null) {
                                try {
                                    clientSocket.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            StatusResponseHolder response = (StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{serverSocket.getLocalPort()}))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8)).get();
            Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
            Assert.assertEquals((Object)"hello!", (Object)response.getContent());
        }
        finally {
            exec.shutdownNow();
            serverSocket.close();
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressionCodecConfig() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final ServerSocket serverSocket = new ServerSocket(0);
        final AtomicBoolean foundAcceptEncoding = new AtomicBoolean();
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        Throwable throwable = null;
                        try {
                            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));
                            Throwable throwable2 = null;
                            try {
                                OutputStream out = clientSocket.getOutputStream();
                                Throwable throwable3 = null;
                                try {
                                    String header;
                                    while (!(header = in.readLine()).equals("")) {
                                        if (!header.equals("Accept-Encoding: identity")) continue;
                                        foundAcceptEncoding.set(true);
                                    }
                                    out.write("HTTP/1.1 200 OK\r\nContent-Length: 6\r\n\r\nhello!".getBytes(Charsets.UTF_8));
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (out == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    out.close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (in == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                in.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (clientSocket == null) continue;
                            if (throwable != null) {
                                try {
                                    clientSocket.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withCompressionCodec(HttpClientConfig.CompressionCodec.IDENTITY).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            StatusResponseHolder response = (StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{serverSocket.getLocalPort()}))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8)).get();
            Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
            Assert.assertEquals((Object)"hello!", (Object)response.getContent());
            Assert.assertTrue((boolean)foundAcceptEncoding.get());
        }
        finally {
            exec.shutdownNow();
            serverSocket.close();
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFriendlySelfSignedHttpsServer() throws Exception {
        Lifecycle lifecycle = new Lifecycle();
        String keyStorePath = this.getClass().getClassLoader().getResource("keystore.jks").getFile();
        Server server = new Server();
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword("abc123");
        sslContextFactory.setKeyManagerPassword("abc123");
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        sslConnector.setPort(0);
        server.setConnectors(new Connector[]{sslConnector});
        server.start();
        try {
            SSLContext mySsl = HttpClientInit.sslContextWithTrustedKeyStore((String)keyStorePath, (String)"abc123");
            HttpClientConfig trustingConfig = HttpClientConfig.builder().withSslContext(mySsl).build();
            HttpClient trustingClient = HttpClientInit.createClient((HttpClientConfig)trustingConfig, (Lifecycle)lifecycle);
            HttpClientConfig skepticalConfig = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient skepticalClient = HttpClientInit.createClient((HttpClientConfig)skepticalConfig, (Lifecycle)lifecycle);
            HttpResponseStatus status = ((StatusResponseHolder)trustingClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{sslConnector.getLocalPort()}))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8)).get()).getStatus();
            Assert.assertEquals((long)404L, (long)status.getCode());
            ListenableFuture response1 = trustingClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://127.0.0.1:%d/", (Object[])new Object[]{sslConnector.getLocalPort()}))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable ea = null;
            try {
                response1.get();
            }
            catch (ExecutionException e) {
                ea = e.getCause();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)(ea instanceof ChannelException));
            Assert.assertTrue((String)"Expected error message", (boolean)ea.getCause().getMessage().matches(".*Failed to handshake.*"));
            ListenableFuture response2 = skepticalClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{sslConnector.getLocalPort()}))), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8));
            Throwable eb = null;
            try {
                response2.get();
            }
            catch (ExecutionException e) {
                eb = e.getCause();
            }
            Assert.assertNotNull((String)"ChannelException thrown by 'get'", (Object)eb);
            Assert.assertTrue((String)"Root cause is SSLHandshakeException", (boolean)(eb.getCause().getCause() instanceof SSLHandshakeException));
        }
        finally {
            lifecycle.stop();
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testHttpBin() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            HttpResponseStatus status = ((StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL("https://httpbin.org/get")), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8)).get()).getStatus();
            Assert.assertEquals((long)200L, (long)status.getCode());
            status = ((StatusResponseHolder)client.go(new Request(HttpMethod.POST, new URL("https://httpbin.org/post")).setContent(new byte[]{97, 98, 99, 1, 2, 3}), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8)).get()).getStatus();
            Assert.assertEquals((long)200L, (long)status.getCode());
        }
        finally {
            lifecycle.stop();
        }
    }
}

