/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.guava;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.junit.Assert;
import org.junit.Test;

public class WithEffectSequenceTest {
    @Test
    public void testConsistentEffectApplicationOrder() {
        final AtomicInteger effect1 = new AtomicInteger();
        final AtomicInteger effect2 = new AtomicInteger();
        final AtomicInteger counter = new AtomicInteger();
        Sequence sequence = Sequences.withEffect((Sequence)Sequences.withEffect((Sequence)Sequences.simple(Arrays.asList(1, 2, 3)), (Runnable)new Runnable(){

            @Override
            public void run() {
                effect1.set(counter.incrementAndGet());
            }
        }, (Executor)MoreExecutors.sameThreadExecutor()), (Runnable)new Runnable(){

            @Override
            public void run() {
                effect2.set(counter.incrementAndGet());
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        Sequences.toList((Sequence)sequence, new ArrayList());
        Assert.assertEquals((long)1L, (long)effect1.get());
        Assert.assertEquals((long)2L, (long)effect2.get());
        Sequence yieldingSequence = Sequences.limit((Sequence)sequence, (int)4);
        Sequences.toList((Sequence)yieldingSequence, new ArrayList());
        Assert.assertEquals((long)3L, (long)effect1.get());
        Assert.assertEquals((long)4L, (long)effect2.get());
    }

    @Test
    public void testEffectExecutedIfWrappedSequenceThrowsExceptionFromClose() {
        Sequence baseSeq = Sequences.simple(Arrays.asList(1, 2, 3));
        Sequence throwingSeq = Sequences.withBaggage((Sequence)baseSeq, (Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                throw new RuntimeException();
            }
        });
        final AtomicBoolean effectExecuted = new AtomicBoolean();
        Sequence seqWithEffect = Sequences.withEffect((Sequence)throwingSeq, (Runnable)new Runnable(){

            @Override
            public void run() {
                effectExecuted.set(true);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        try {
            Sequences.toList((Sequence)seqWithEffect, new ArrayList());
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)effectExecuted.get());
        }
    }
}

