/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.guava;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.junit.Assert;
import org.junit.Test;

public class LimitedSequenceTest {
    @Test
    public void testSanityAccumulate() throws Exception {
        List<Integer> nums = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        int threshold = 5;
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.limit((Sequence)Sequences.simple(nums), (int)5), Lists.newArrayList((Iterable)Iterables.limit(nums, (int)5)));
    }

    @Test
    public void testTwo() throws Exception {
        List<Integer> nums = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        int threshold = 2;
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.limit((Sequence)Sequences.simple(nums), (int)2), Lists.newArrayList((Iterable)Iterables.limit(nums, (int)2)));
    }

    @Test
    public void testOne() throws Exception {
        List<Integer> nums = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        boolean threshold = true;
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.limit((Sequence)Sequences.simple(nums), (int)1), Lists.newArrayList((Iterable)Iterables.limit(nums, (int)1)));
    }

    @Test
    public void testNoSideEffects() throws Exception {
        List<Integer> nums = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        final AtomicLong accumulated = new AtomicLong(0L);
        Sequence seq = Sequences.limit((Sequence)Sequences.simple((Iterable)Iterables.transform(nums, (Function)new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                accumulated.addAndGet(input.intValue());
                return input;
            }
        })), (int)5);
        Assert.assertEquals((long)10L, (long)((Integer)seq.accumulate((Object)0, (Accumulator)new IntAdditionAccumulator())).intValue());
        Assert.assertEquals((long)10L, (long)accumulated.get());
        Assert.assertEquals((long)10L, (long)((Integer)seq.accumulate((Object)0, (Accumulator)new IntAdditionAccumulator())).intValue());
        Assert.assertEquals((long)20L, (long)accumulated.get());
    }

    private static class IntAdditionAccumulator
    implements Accumulator<Integer, Integer> {
        private IntAdditionAccumulator() {
        }

        public Integer accumulate(Integer accumulated, Integer in) {
            return accumulated + in;
        }
    }
}

