/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common;

import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void fromUtf8ConversionTest() throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((byte[])bytes));
        String abcd = "abcd";
        Assert.assertEquals((Object)abcd, (Object)StringUtils.fromUtf8((byte[])abcd.getBytes(StringUtils.UTF8_STRING)));
    }

    @Test
    public void toUtf8ConversionTest() {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        byte[] strBytes = StringUtils.toUtf8((String)"abcd");
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)strBytes[i]);
        }
    }

    @Test
    public void fromUtf8ByteBufferHeap() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)4));
        bytes.rewind();
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test
    public void testMiddleOfByteArrayConversion() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        bytes.position(1).limit(3);
        Assert.assertEquals((Object)"bc", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)2));
        bytes.position(1);
        Assert.assertEquals((Object)"bc", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test(expected=BufferUnderflowException.class)
    public void testOutOfBounds() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        bytes.position(1).limit(3);
        StringUtils.fromUtf8((ByteBuffer)bytes, (int)3);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerByteBuffer() {
        StringUtils.fromUtf8((ByteBuffer)null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerByteArray() {
        StringUtils.fromUtf8((byte[])null);
    }

    @Test
    public void fromUtf8ByteBufferDirect() {
        ByteBuffer bytes = ByteBuffer.allocateDirect(4);
        bytes.put(new byte[]{97, 98, 99, 100});
        bytes.rewind();
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)4));
        bytes.rewind();
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test
    public void testCharsetShowsUpAsDeprecated() {
        Assert.assertNotNull((Object)StringUtils.UTF8_CHARSET);
    }

    @Test
    public void testNonStrictFormat() {
        Assert.assertEquals((Object)"test%d; format", (Object)StringUtils.nonStrictFormat((String)"test%d", (Object[])new Object[]{"format"}));
        Assert.assertEquals((Object)"test%s%s; format", (Object)StringUtils.nonStrictFormat((String)"test%s%s", (Object[])new Object[]{"format"}));
    }

    @Test
    public void testRemoveCharacter() {
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)"123", (char)','));
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)"123,", (char)','));
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)",1,,2,3,", (char)','));
        Assert.assertEquals((Object)"", (Object)StringUtils.removeChar((String)",,", (char)','));
    }
}

