/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.utils;

import java.io.UnsupportedEncodingException;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    public static final String[] TEST_STRINGS = new String[]{"peach", "p\u00e9ch\u00e9", "p\u00eache", "sin", "", "\u2603", "C", "c", "\u00c7", "\u00e7", "G", "g", "\u011e", "\u011f", "I", "\u0131", "\u0130", "i", "O", "o", "\u00d6", "\u00f6", "S", "s", "\u015e", "\u015f", "U", "u", "\u00dc", "\u00fc", "\u00e4", "\ud841\udf0e", "\ud841\udf31", "\ud844\udc5c", "\ud84f\udcb7", "\ud860\udee2", "\ud867\udd98", "n\u0303", "n", "\ufb00", "ff", "\u00c5", "\u00c5", "\u212b"};

    @Test
    public void binaryLengthAsUTF8Test() throws UnsupportedEncodingException {
        for (String string : TEST_STRINGS) {
            Assert.assertEquals((long)StringUtils.toUtf8((String)string).length, (long)StringUtils.estimatedBinaryLengthAsUTF8((String)string));
        }
    }

    @Test
    public void binaryLengthAsUTF8InvalidTest() throws UnsupportedEncodingException {
        String invalid = "\ud841";
        Assert.assertEquals((long)1L, (long)StringUtils.toUtf8((String)invalid).length);
        Assert.assertEquals((long)4L, (long)StringUtils.estimatedBinaryLengthAsUTF8((String)invalid));
        invalid = "\ud841\ud841";
        Assert.assertEquals((long)2L, (long)StringUtils.toUtf8((String)invalid).length);
        Assert.assertEquals((long)4L, (long)StringUtils.estimatedBinaryLengthAsUTF8((String)invalid));
        invalid = "\ud841P";
        Assert.assertEquals((long)2L, (long)StringUtils.toUtf8((String)invalid).length);
        Assert.assertEquals((long)4L, (long)StringUtils.estimatedBinaryLengthAsUTF8((String)invalid));
        invalid = "\udee2\ud841";
        Assert.assertEquals((long)2L, (long)StringUtils.toUtf8((String)invalid).length);
        Assert.assertEquals((long)4L, (long)StringUtils.estimatedBinaryLengthAsUTF8((String)invalid));
    }
}

