/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StupidPoolTest {
    private Supplier<String> generator;
    private StupidPool<String> poolOfString;
    private ResourceHolder<String> resourceHolderObj;
    private String defaultString = new String("test");

    @Before
    public void setUp() {
        this.generator = (Supplier)EasyMock.createMock(Supplier.class);
        EasyMock.expect((Object)this.generator.get()).andReturn((Object)this.defaultString).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.generator});
        this.poolOfString = new StupidPool("poolOfString", this.generator);
        this.resourceHolderObj = this.poolOfString.take();
    }

    @After
    public void tearDown() throws IOException {
        if (this.resourceHolderObj != null) {
            this.resourceHolderObj.close();
        }
    }

    @Test
    public void testTake() {
        Assert.assertThat(this.resourceHolderObj, (Matcher)new IsInstanceOf(ResourceHolder.class));
        Object expectedObject = this.resourceHolderObj.get();
        Assert.assertEquals((Object)expectedObject, (Object)this.defaultString);
    }

    @Test(expected=ISE.class)
    public void testExceptionInResourceHolderGet() throws IOException {
        this.resourceHolderObj.close();
        this.resourceHolderObj.get();
    }

    @Test(timeout=60000L)
    public void testResourceHandlerClearedByJVM() throws InterruptedException {
        String leakedString = this.createDanglingObjectHandler();
        for (int i = 0; i < 6000 && this.poolOfString.leakedObjectsCount() == 0L; ++i) {
            System.gc();
            byte[] garbage = new byte[10000000];
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)leakedString, (long)1L, (long)this.poolOfString.leakedObjectsCount());
    }

    private String createDanglingObjectHandler() {
        return (String)this.poolOfString.take().get();
    }
}

