/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.collections.IteratorShell;
import org.apache.hive.druid.io.druid.collections.OrderedMergeIterator;
import org.junit.Assert;
import org.junit.Test;

public class OrderedMergeIteratorTest {
    @Test
    public void testSanity() throws Exception {
        ArrayList iterators = Lists.newArrayList();
        iterators.add(Arrays.asList(1, 3, 5, 7, 9).iterator());
        iterators.add(Arrays.asList(2, 8).iterator());
        iterators.add(Arrays.asList(4, 6, 8).iterator());
        OrderedMergeIterator iter = new OrderedMergeIterator((Comparator)Ordering.natural(), iterators.iterator());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9), (Object)Lists.newArrayList((Iterator)iter));
    }

    @Test
    public void testScrewsUpOnOutOfOrderBeginningOfList() throws Exception {
        ArrayList iterators = Lists.newArrayList();
        iterators.add(Arrays.asList(1, 3, 5, 7, 9).iterator());
        iterators.add(Arrays.asList(4, 6).iterator());
        iterators.add(Arrays.asList(2, 8).iterator());
        OrderedMergeIterator iter = new OrderedMergeIterator((Comparator)Ordering.natural(), iterators.iterator());
        Assert.assertEquals(Arrays.asList(1, 3, 4, 2, 5, 6, 7, 8, 9), (Object)Lists.newArrayList((Iterator)iter));
    }

    @Test
    public void testScrewsUpOnOutOfOrderInList() throws Exception {
        ArrayList iterators = Lists.newArrayList();
        iterators.add(Arrays.asList(1, 3, 5, 4, 7, 9).iterator());
        iterators.add(Arrays.asList(2, 8).iterator());
        iterators.add(Arrays.asList(4, 6).iterator());
        OrderedMergeIterator iter = new OrderedMergeIterator((Comparator)Ordering.natural(), iterators.iterator());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 4, 6, 7, 8, 9), (Object)Lists.newArrayList((Iterator)iter));
    }

    @Test
    public void testLaziness() throws Exception {
        final boolean[] done = new boolean[]{false, false};
        ArrayList iterators = Lists.newArrayList();
        iterators.add(new IteratorShell<Integer>(Arrays.asList(1, 2, 3).iterator()){

            @Override
            public boolean hasNext() {
                boolean retVal = super.hasNext();
                if (!retVal) {
                    done[0] = true;
                }
                return retVal;
            }
        });
        iterators.add(new IteratorShell<Integer>(Arrays.asList(4, 5, 6).iterator()){
            int count;
            {
                super(base);
                this.count = 0;
            }

            @Override
            public boolean hasNext() {
                boolean retVal;
                if (this.count >= 1) {
                    Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                }
                if (!(retVal = super.hasNext())) {
                    done[1] = true;
                }
                return retVal;
            }

            @Override
            public Integer next() {
                if (this.count >= 1) {
                    Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                }
                ++this.count;
                return (Integer)super.next();
            }
        });
        iterators.add(new IteratorShell<Integer>(Arrays.asList(7, 8, 9).iterator()){
            int count;
            {
                super(base);
                this.count = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.count >= 1) {
                    Assert.assertTrue((String)"Second iterator not complete", (boolean)done[1]);
                }
                Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                return super.hasNext();
            }

            @Override
            public Integer next() {
                if (this.count >= 1) {
                    Assert.assertTrue((String)"Second iterator not complete", (boolean)done[1]);
                }
                Assert.assertTrue((String)"First iterator not complete", (boolean)done[0]);
                ++this.count;
                return (Integer)super.next();
            }
        });
        OrderedMergeIterator iter = new OrderedMergeIterator((Comparator)Ordering.natural(), iterators.iterator());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9), (Object)Lists.newArrayList((Iterator)iter));
    }

    @Test(expected=NoSuchElementException.class)
    public void testNoElementInNext() {
        ArrayList iterators = Lists.newArrayList();
        OrderedMergeIterator iter = new OrderedMergeIterator((Comparator)Ordering.natural(), iterators.iterator());
        iter.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() {
        ArrayList iterators = Lists.newArrayList();
        OrderedMergeIterator iter = new OrderedMergeIterator((Comparator)Ordering.natural(), iterators.iterator());
        iter.remove();
    }
}

