/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.io.druid.client.DirectDruidClient;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.selector.ConnectionCountServerSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.io.druid.client.selector.ServerSelector;
import org.apache.hive.druid.io.druid.client.selector.ServerSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.io.druid.java.util.http.client.Request;
import org.apache.hive.druid.io.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.ReflectionQueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class DirectDruidClientTest {
    private final Map<String, Object> defaultContext = new HashMap<String, Object>();

    public DirectDruidClientTest() {
        this.defaultContext.put("queryFailTime", Long.MAX_VALUE);
        this.defaultContext.put("queryTotalBytesGathered", new AtomicLong());
    }

    @Test
    public void testRun() throws Exception {
        HttpClient httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        URL url = new URL("http://foo/druid/v2/");
        SettableFuture futureResult = SettableFuture.create();
        Capture capturedRequest = EasyMock.newCapture();
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)futureResult).times(1);
        SettableFuture futureException = SettableFuture.create();
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)futureException).times(1);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)SettableFuture.create()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{httpClient});
        ServerSelector serverSelector = new ServerSelector(new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L), (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()));
        DirectDruidClient client1 = new DirectDruidClient((QueryToolChestWarehouse)new ReflectionQueryToolChestWarehouse(), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (ObjectMapper)new DefaultObjectMapper(), httpClient, "http", "foo", (ServiceEmitter)new NoopServiceEmitter());
        DirectDruidClient client2 = new DirectDruidClient((QueryToolChestWarehouse)new ReflectionQueryToolChestWarehouse(), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (ObjectMapper)new DefaultObjectMapper(), httpClient, "http", "foo2", (ServiceEmitter)new NoopServiceEmitter());
        QueryableDruidServer queryableDruidServer1 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), client1);
        serverSelector.addServerAndUpdateSegment(queryableDruidServer1, serverSelector.getSegment());
        QueryableDruidServer queryableDruidServer2 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), client2);
        serverSelector.addServerAndUpdateSegment(queryableDruidServer2, serverSelector.getSegment());
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        Sequence s1 = client1.run(QueryPlus.wrap((Query)query), this.defaultContext);
        Assert.assertTrue((boolean)capturedRequest.hasCaptured());
        Assert.assertEquals((Object)url, (Object)((Request)capturedRequest.getValue()).getUrl());
        Assert.assertEquals((Object)HttpMethod.POST, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((long)1L, (long)client1.getNumOpenConnections());
        Sequence s2 = client1.run(QueryPlus.wrap((Query)query), this.defaultContext);
        Assert.assertEquals((long)2L, (long)client1.getNumOpenConnections());
        futureException.setException((Throwable)new ReadTimeoutException());
        Assert.assertEquals((long)1L, (long)client1.getNumOpenConnections());
        Sequence s3 = client1.run(QueryPlus.wrap((Query)query), this.defaultContext);
        Sequence s4 = client1.run(QueryPlus.wrap((Query)query), this.defaultContext);
        Sequence s5 = client1.run(QueryPlus.wrap((Query)query), this.defaultContext);
        Assert.assertTrue((client1.getNumOpenConnections() == 4 ? 1 : 0) != 0);
        futureResult.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"[{\"timestamp\":\"2014-01-01T01:02:03Z\", \"result\": 42.0}]")));
        List results = Sequences.toList((Sequence)s1, (List)Lists.newArrayList());
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)DateTimes.of((String)"2014-01-01T01:02:03Z"), (Object)((Result)results.get(0)).getTimestamp());
        Assert.assertEquals((long)3L, (long)client1.getNumOpenConnections());
        client2.run(QueryPlus.wrap((Query)query), this.defaultContext);
        client2.run(QueryPlus.wrap((Query)query), this.defaultContext);
        Assert.assertTrue((client2.getNumOpenConnections() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((serverSelector.pick() == queryableDruidServer2 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{httpClient});
    }

    @Test
    public void testCancel() throws Exception {
        HttpClient httpClient = (HttpClient)EasyMock.createStrictMock(HttpClient.class);
        Capture capturedRequest = EasyMock.newCapture();
        ListenableFuture cancelledFuture = Futures.immediateCancelledFuture();
        SettableFuture cancellationFuture = SettableFuture.create();
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)cancelledFuture).once();
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)cancellationFuture).once();
        EasyMock.replay((Object[])new Object[]{httpClient});
        ServerSelector serverSelector = new ServerSelector(new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L), (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()));
        DirectDruidClient client1 = new DirectDruidClient((QueryToolChestWarehouse)new ReflectionQueryToolChestWarehouse(), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (ObjectMapper)new DefaultObjectMapper(), httpClient, "http", "foo", (ServiceEmitter)new NoopServiceEmitter());
        QueryableDruidServer queryableDruidServer1 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), client1);
        serverSelector.addServerAndUpdateSegment(queryableDruidServer1, serverSelector.getSegment());
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        cancellationFuture.set((Object)new StatusResponseHolder(HttpResponseStatus.OK, new StringBuilder("cancelled")));
        Sequence results = client1.run(QueryPlus.wrap((Query)query), this.defaultContext);
        Assert.assertEquals((Object)HttpMethod.DELETE, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((long)0L, (long)client1.getNumOpenConnections());
        QueryInterruptedException exception = null;
        try {
            Sequences.toList((Sequence)results, (List)Lists.newArrayList());
        }
        catch (QueryInterruptedException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)((Object)exception));
        EasyMock.verify((Object[])new Object[]{httpClient});
    }

    @Test
    public void testQueryInterruptionExceptionLogMessage() throws JsonProcessingException {
        HttpClient httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        SettableFuture interruptionFuture = SettableFuture.create();
        Capture capturedRequest = EasyMock.newCapture();
        String hostName = "localhost:8080";
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)interruptionFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{httpClient});
        DataSegment dataSegment = new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L);
        ServerSelector serverSelector = new ServerSelector(dataSegment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()));
        DirectDruidClient client1 = new DirectDruidClient((QueryToolChestWarehouse)new ReflectionQueryToolChestWarehouse(), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (ObjectMapper)new DefaultObjectMapper(), httpClient, "http", hostName, (ServiceEmitter)new NoopServiceEmitter());
        QueryableDruidServer queryableDruidServer = new QueryableDruidServer(new DruidServer("test1", hostName, null, 0L, ServerType.HISTORICAL, "_default_tier", 0), client1);
        serverSelector.addServerAndUpdateSegment(queryableDruidServer, dataSegment);
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        interruptionFuture.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"{\"error\":\"testing1\",\"errorMessage\":\"testing2\"}")));
        Sequence results = client1.run(QueryPlus.wrap((Query)query), this.defaultContext);
        QueryInterruptedException actualException = null;
        try {
            Sequences.toList((Sequence)results, (List)Lists.newArrayList());
        }
        catch (QueryInterruptedException e) {
            actualException = e;
        }
        Assert.assertNotNull((Object)((Object)actualException));
        Assert.assertEquals((Object)"testing1", (Object)actualException.getErrorCode());
        Assert.assertEquals((Object)"testing2", (Object)actualException.getMessage());
        Assert.assertEquals((Object)hostName, (Object)actualException.getHost());
        EasyMock.verify((Object[])new Object[]{httpClient});
    }
}

