/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.EmitterTest;
import org.apache.hive.druid.com.metamx.emitter.core.Emitters;
import org.apache.hive.druid.com.metamx.emitter.core.Event;
import org.apache.hive.druid.com.metamx.emitter.core.GoHandler;
import org.apache.hive.druid.com.metamx.emitter.core.GoHandlers;
import org.apache.hive.druid.com.metamx.emitter.core.MockHttpClient;
import org.apache.hive.druid.com.metamx.emitter.core.ParametrizedUriEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.UnitEvent;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParametrizedUriEmitterTest {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private MockHttpClient httpClient;
    private Lifecycle lifecycle;

    @Before
    public void setUp() throws Exception {
        this.httpClient = new MockHttpClient();
    }

    @After
    public void tearDown() throws Exception {
        if (this.lifecycle != null) {
            this.lifecycle.stop();
        }
    }

    private Emitter parametrizedEmmiter(String uriPattern) throws Exception {
        Properties props = new Properties();
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.type", "parametrized");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.recipientBaseUrlPattern", uriPattern);
        this.lifecycle = new Lifecycle();
        Emitter emitter = Emitters.create((Properties)props, (AsyncHttpClient)this.httpClient, (Lifecycle)this.lifecycle);
        Assert.assertEquals(ParametrizedUriEmitter.class, emitter.getClass());
        this.lifecycle.start();
        return emitter;
    }

    @Test
    public void testParametrizedEmitterCreated() throws Exception {
        this.parametrizedEmmiter("http://example.com/");
    }

    @Test
    public void testEmitterWithFeedUriExtractor() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{feed}");
        final List<UnitEvent> events = Arrays.asList(new UnitEvent("test", 1), new UnitEvent("test", 2));
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            public ListenableFuture<Response> go(Request request) throws JsonProcessingException {
                Assert.assertEquals((Object)"http://example.com/test", (Object)request.getUrl());
                Assert.assertEquals((Object)String.format("[%s,%s]\n", jsonMapper.writeValueAsString(events.get(0)), jsonMapper.writeValueAsString(events.get(1))), (Object)Charsets.UTF_8.decode(request.getByteBufferData().slice()).toString());
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        }.times(1));
        for (UnitEvent event : events) {
            emitter.emit((Event)event);
        }
        emitter.flush();
        Assert.assertTrue((boolean)this.httpClient.succeeded());
    }

    @Test
    public void testEmitterWithMultipleFeeds() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{feed}");
        List<UnitEvent> events = Arrays.asList(new UnitEvent("test1", 1), new UnitEvent("test2", 2));
        final HashMap results = new HashMap();
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                results.put(request.getUrl().toString(), Charsets.UTF_8.decode(request.getByteBufferData().slice()).toString());
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        }.times(2));
        for (UnitEvent event : events) {
            emitter.emit((Event)event);
        }
        emitter.flush();
        Assert.assertTrue((boolean)this.httpClient.succeeded());
        ImmutableMap expected = ImmutableMap.of((Object)"http://example.com/test1", (Object)String.format("[%s]\n", jsonMapper.writeValueAsString((Object)events.get(0))), (Object)"http://example.com/test2", (Object)String.format("[%s]\n", jsonMapper.writeValueAsString((Object)events.get(1))));
        Assert.assertEquals((Object)expected, results);
    }

    @Test
    public void testEmitterWithParametrizedUriExtractor() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{key1}/{key2}");
        final List<UnitEvent> events = Arrays.asList(new UnitEvent("test", 1, (Map<String, String>)ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2")), new UnitEvent("test", 2, (Map<String, String>)ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2")));
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) throws JsonProcessingException {
                Assert.assertEquals((Object)"http://example.com/val1/val2", (Object)request.getUrl());
                Assert.assertEquals((Object)String.format("[%s,%s]\n", jsonMapper.writeValueAsString(events.get(0)), jsonMapper.writeValueAsString(events.get(1))), (Object)Charsets.UTF_8.decode(request.getByteBufferData().slice()).toString());
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        }.times(1));
        for (UnitEvent event : events) {
            emitter.emit((Event)event);
        }
        emitter.flush();
        Assert.assertTrue((boolean)this.httpClient.succeeded());
    }

    @Test
    public void failEmitMalformedEvent() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{keyNotSetInEvents}");
        UnitEvent event = new UnitEvent("test", 1);
        this.httpClient.setGoHandler(GoHandlers.failingHandler());
        try {
            emitter.emit((Event)event);
            emitter.flush();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)String.format("ParametrizedUriExtractor with pattern http://example.com/{keyNotSetInEvents} requires keyNotSetInEvents to be set in event, but found %s", event.toMap()));
        }
    }
}

