/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.emitter.core.Emitters;
import org.apache.hive.druid.com.metamx.emitter.core.LoggingEmitter;
import org.apache.hive.druid.com.metamx.emitter.core.LoggingEmitterConfig;
import org.junit.Assert;
import org.junit.Test;

public class LoggingEmitterConfigTest {
    @Test
    public void testDefaults() {
        Properties props = new Properties();
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)LoggingEmitter.class.getName(), (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"info", (Object)config.getLogLevel());
    }

    @Test
    public void testDefaultsLegacy() {
        Properties props = new Properties();
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeLoggingMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)LoggingEmitter.class.getName(), (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"debug", (Object)config.getLogLevel());
    }

    @Test
    public void testSettingEverything() {
        Properties props = new Properties();
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.loggerClass", "Foo");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.logLevel", "INFO");
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)"Foo", (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"INFO", (Object)config.getLogLevel());
    }

    @Test
    public void testSettingEverythingLegacy() {
        Properties props = new Properties();
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.logging.class", "Foo");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.logging.level", "INFO");
        ObjectMapper objectMapper = new ObjectMapper();
        LoggingEmitterConfig config = (LoggingEmitterConfig)objectMapper.convertValue((Object)Emitters.makeLoggingMap((Properties)props), LoggingEmitterConfig.class);
        Assert.assertEquals((String)"getLoggerClass", (Object)"Foo", (Object)config.getLoggerClass());
        Assert.assertEquals((String)"getLogLevel", (Object)"INFO", (Object)config.getLogLevel());
    }
}

