/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.io.smoosh;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.common.BufferUtils;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.com.metamx.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.com.metamx.common.io.smoosh.SmooshedWriter;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SmooshedFileMapperTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testSanity() throws Exception {
        File baseDir = this.folder.newFolder("base");
        try (FileSmoosher smoosher = new FileSmoosher(baseDir, 21);){
            for (int i = 0; i < 20; ++i) {
                File tmpFile = this.folder.newFile(String.format("smoosh-%s.bin", i));
                Files.write((byte[])Ints.toByteArray((int)i), (File)tmpFile);
                smoosher.add(String.format("%d", i), tmpFile);
            }
        }
        Object[] files = baseDir.listFiles();
        Assert.assertNotNull((Object)files);
        Arrays.sort(files);
        Assert.assertEquals((int)5, (int)files.length);
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)FileSmoosher.makeChunkFile((File)baseDir, (int)i), (Object)files[i]);
        }
        Assert.assertEquals((Object)FileSmoosher.metaFile((File)baseDir), (Object)files[files.length - 1]);
        try (SmooshedFileMapper mapper = SmooshedFileMapper.load((File)baseDir);){
            for (int i = 0; i < 20; ++i) {
                ByteBuffer buf = mapper.mapFile(String.format("%d", i));
                Assert.assertEquals((int)0, (int)buf.position());
                Assert.assertEquals((int)4, (int)buf.remaining());
                Assert.assertEquals((int)4, (int)buf.capacity());
                Assert.assertEquals((int)i, (int)buf.getInt());
            }
        }
    }

    @Test
    public void testBehaviorWhenReportedSizesLargeAndExceptionIgnored() throws Exception {
        File baseDir = this.folder.newFolder("base");
        try (FileSmoosher smoosher = new FileSmoosher(baseDir, 21);){
            for (int i = 0; i < 20; ++i) {
                SmooshedWriter writer = smoosher.addWithSmooshedWriter(String.format("%d", i), 7L);
                writer.write(ByteBuffer.wrap(Ints.toByteArray((int)i)));
                try {
                    writer.close();
                    Assert.fail((String)"IOException expected");
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Object[] files = baseDir.listFiles();
        Assert.assertNotNull((Object)files);
        Arrays.sort(files);
        Assert.assertEquals((int)6, (int)files.length);
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)FileSmoosher.makeChunkFile((File)baseDir, (int)i), (Object)files[i]);
        }
        Assert.assertEquals((Object)FileSmoosher.metaFile((File)baseDir), (Object)files[files.length - 1]);
        try (SmooshedFileMapper mapper = SmooshedFileMapper.load((File)baseDir);){
            for (int i = 0; i < 20; ++i) {
                ByteBuffer buf = mapper.mapFile(String.format("%d", i));
                Assert.assertEquals((int)0, (int)buf.position());
                Assert.assertEquals((int)4, (int)buf.remaining());
                Assert.assertEquals((int)4, (int)buf.capacity());
                Assert.assertEquals((int)i, (int)buf.getInt());
            }
        }
    }

    @Test
    public void testBehaviorWhenReportedSizesSmall() throws Exception {
        File baseDir = this.folder.newFolder("base");
        try (FileSmoosher smoosher = new FileSmoosher(baseDir, 21);){
            boolean exceptionThrown = false;
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter("1", 2L);){
                writer.write(ByteBuffer.wrap(Ints.toByteArray((int)1)));
            }
            catch (ISE e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Liar!!!"));
                exceptionThrown = true;
            }
            Assert.assertTrue((boolean)exceptionThrown);
            File[] files = baseDir.listFiles();
            Assert.assertNotNull((Object)files);
            Assert.assertEquals((int)1, (int)files.length);
        }
    }

    @Test
    public void testDeterministicFileUnmapping() throws IOException {
        File baseDir = this.folder.newFolder("base");
        long totalMemoryUsedBeforeAddingFile = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        try (FileSmoosher smoosher = new FileSmoosher(baseDir);){
            File dataFile = this.folder.newFile("data.bin");
            try (RandomAccessFile raf = new RandomAccessFile(dataFile, "rw");){
                raf.setLength(0x100000L);
            }
            smoosher.add(dataFile);
        }
        long totalMemoryUsedAfterAddingFile = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        Assert.assertEquals((long)totalMemoryUsedBeforeAddingFile, (long)totalMemoryUsedAfterAddingFile);
    }
}

