/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.metamx.common.JodaUtils;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class JodaUtilsTest {
    @Test
    public void testUmbrellaIntervalsSimple() throws Exception {
        List<Interval> intervals = Arrays.asList(new Interval((Object)"2011-03-03/2011-03-04"), new Interval((Object)"2011-01-01/2011-01-02"), new Interval((Object)"2011-02-01/2011-02-05"), new Interval((Object)"2011-02-03/2011-02-08"), new Interval((Object)"2011-01-01/2011-01-03"), new Interval((Object)"2011-03-01/2011-03-02"), new Interval((Object)"2011-03-05/2011-03-06"), new Interval((Object)"2011-02-01/2011-02-02"));
        Assert.assertEquals((Object)new Interval((Object)"2011-01-01/2011-03-06"), (Object)JodaUtils.umbrellaInterval(intervals));
    }

    @Test
    public void testUmbrellaIntervalsNull() throws Exception {
        List<Interval> intervals = Arrays.asList(new Interval[0]);
        IllegalArgumentException thrown = null;
        try {
            Interval interval = JodaUtils.umbrellaInterval(intervals);
        }
        catch (IllegalArgumentException e) {
            thrown = e;
        }
        Assert.assertNotNull((String)"Empty list of intervals", (Object)thrown);
    }

    @Test
    public void testCondenseIntervalsSimple() throws Exception {
        List<Interval> intervals = Arrays.asList(new Interval((Object)"2011-01-01/2011-01-02"), new Interval((Object)"2011-01-02/2011-01-03"), new Interval((Object)"2011-02-01/2011-02-05"), new Interval((Object)"2011-02-01/2011-02-02"), new Interval((Object)"2011-02-03/2011-02-08"), new Interval((Object)"2011-03-01/2011-03-02"), new Interval((Object)"2011-03-03/2011-03-04"), new Interval((Object)"2011-03-05/2011-03-06"));
        Assert.assertEquals(Arrays.asList(new Interval((Object)"2011-01-01/2011-01-03"), new Interval((Object)"2011-02-01/2011-02-08"), new Interval((Object)"2011-03-01/2011-03-02"), new Interval((Object)"2011-03-03/2011-03-04"), new Interval((Object)"2011-03-05/2011-03-06")), (Object)JodaUtils.condenseIntervals(intervals));
    }

    @Test
    public void testCondenseIntervalsMixedUp() throws Exception {
        List<Interval> intervals = Arrays.asList(new Interval((Object)"2011-01-01/2011-01-02"), new Interval((Object)"2011-01-02/2011-01-03"), new Interval((Object)"2011-02-01/2011-02-05"), new Interval((Object)"2011-02-01/2011-02-02"), new Interval((Object)"2011-02-03/2011-02-08"), new Interval((Object)"2011-03-01/2011-03-02"), new Interval((Object)"2011-03-03/2011-03-04"), new Interval((Object)"2011-03-05/2011-03-06"));
        for (int i = 0; i < 20; ++i) {
            Collections.shuffle(intervals);
            Assert.assertEquals(Arrays.asList(new Interval((Object)"2011-01-01/2011-01-03"), new Interval((Object)"2011-02-01/2011-02-08"), new Interval((Object)"2011-03-01/2011-03-02"), new Interval((Object)"2011-03-03/2011-03-04"), new Interval((Object)"2011-03-05/2011-03-06")), (Object)JodaUtils.condenseIntervals(intervals));
        }
    }
}

