/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.ODEIntegrator;
import org.apache.commons.math3.ode.TestProblemAbstract;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class TestProblemHandler
implements StepHandler {
    private TestProblemAbstract problem;
    private double maxValueError;
    private double maxTimeError;
    private double lastError;
    private double lastTime;
    private ODEIntegrator integrator;
    private double expectedStepStart;

    public TestProblemHandler(TestProblemAbstract problem, ODEIntegrator integrator) {
        this.problem = problem;
        this.integrator = integrator;
        this.maxValueError = 0.0;
        this.maxTimeError = 0.0;
        this.lastError = 0.0;
        this.expectedStepStart = Double.NaN;
    }

    public void init(double t0, double[] y0, double t) {
        this.maxValueError = 0.0;
        this.maxTimeError = 0.0;
        this.lastError = 0.0;
        this.expectedStepStart = Double.NaN;
    }

    public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
        double start = this.integrator.getCurrentStepStart();
        if (FastMath.abs((double)((start - this.problem.getInitialTime()) / this.integrator.getCurrentSignedStepsize())) > 0.001) {
            if (!Double.isNaN(this.expectedStepStart)) {
                double stepError = FastMath.max((double)this.maxTimeError, (double)FastMath.abs((double)(start - this.expectedStepStart)));
                for (double eventTime : this.problem.getTheoreticalEventsTimes()) {
                    stepError = FastMath.min((double)stepError, (double)FastMath.abs((double)(start - eventTime)));
                }
                this.maxTimeError = FastMath.max((double)this.maxTimeError, (double)stepError);
            }
            this.expectedStepStart = start + this.integrator.getCurrentSignedStepsize();
        }
        double pT = interpolator.getPreviousTime();
        double cT = interpolator.getCurrentTime();
        double[] errorScale = this.problem.getErrorScale();
        if (isLast) {
            double[] interpolatedY = interpolator.getInterpolatedState();
            double[] theoreticalY = this.problem.computeTheoreticalState(cT);
            for (int i = 0; i < interpolatedY.length; ++i) {
                double error = FastMath.abs((double)(interpolatedY[i] - theoreticalY[i]));
                this.lastError = FastMath.max((double)error, (double)this.lastError);
            }
            this.lastTime = cT;
        }
        for (int k = 0; k <= 20; ++k) {
            double time = pT + (double)k * (cT - pT) / 20.0;
            interpolator.setInterpolatedTime(time);
            double[] interpolatedY = interpolator.getInterpolatedState();
            double[] theoreticalY = this.problem.computeTheoreticalState(interpolator.getInterpolatedTime());
            for (int i = 0; i < interpolatedY.length; ++i) {
                double error = errorScale[i] * FastMath.abs((double)(interpolatedY[i] - theoreticalY[i]));
                this.maxValueError = FastMath.max((double)error, (double)this.maxValueError);
            }
        }
    }

    public double getMaximalValueError() {
        return this.maxValueError;
    }

    public double getMaximalTimeError() {
        return this.maxTimeError;
    }

    public int getCalls() {
        return this.problem.getCalls();
    }

    public double getLastError() {
        return this.lastError;
    }

    public double getLastTime() {
        return this.lastTime;
    }
}

