/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultilineRecursiveToStringStyleTest {
    private final String BR = System.lineSeparator();

    @Test
    public void simpleObject() {
        Transaction tx = new Transaction("2014.10.15", 100.0);
        String expected = this.getClassPrefix(tx) + "[" + this.BR + "  amount=100.0," + this.BR + "  date=2014.10.15" + this.BR + "]";
        Assertions.assertEquals((Object)expected, (Object)this.toString(tx));
    }

    @Test
    public void nestedElements() {
        Bank bank;
        Customer customer = new Customer("Douglas Adams");
        customer.bank = bank = new Bank("ASF Bank");
        String exp = this.getClassPrefix(customer) + "[" + this.BR + "  name=Douglas Adams," + this.BR + "  bank=" + this.getClassPrefix(bank) + "[" + this.BR + "    name=ASF Bank" + this.BR + "  ]," + this.BR + "  accounts=<null>" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(customer));
    }

    @Test
    public void nestedAndArray() {
        Account acc = new Account();
        Transaction tx1 = new Transaction("2014.10.14", 100.0);
        Transaction tx2 = new Transaction("2014.10.15", 50.0);
        acc.transactions.add(tx1);
        acc.transactions.add(tx2);
        String expected = this.getClassPrefix(acc) + "[" + this.BR + "  owner=<null>," + this.BR + "  transactions=" + this.getClassPrefix(acc.transactions) + "{" + this.BR + "    " + this.getClassPrefix(tx1) + "[" + this.BR + "      amount=100.0," + this.BR + "      date=2014.10.14" + this.BR + "    ]," + this.BR + "    " + this.getClassPrefix(tx2) + "[" + this.BR + "      amount=50.0," + this.BR + "      date=2014.10.15" + this.BR + "    ]" + this.BR + "  }" + this.BR + "]";
        Assertions.assertEquals((Object)expected, (Object)this.toString(acc));
    }

    @Test
    public void noArray() {
        WithArrays wa = new WithArrays();
        String exp = this.getClassPrefix(wa) + "[" + this.BR + "  boolArray=<null>," + this.BR + "  charArray=<null>," + this.BR + "  intArray=<null>," + this.BR + "  doubleArray=<null>," + this.BR + "  longArray=<null>," + this.BR + "  stringArray=<null>" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void boolArray() {
        WithArrays wa = new WithArrays();
        wa.boolArray = new boolean[]{true, false, true};
        String exp = this.getClassPrefix(wa) + "[" + this.BR + "  boolArray={" + this.BR + "    true," + this.BR + "    false," + this.BR + "    true" + this.BR + "  }," + this.BR + "  charArray=<null>," + this.BR + "  intArray=<null>," + this.BR + "  doubleArray=<null>," + this.BR + "  longArray=<null>," + this.BR + "  stringArray=<null>" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void charArray() {
        WithArrays wa = new WithArrays();
        wa.charArray = new char[]{'a', 'A'};
        String exp = this.getClassPrefix(wa) + "[" + this.BR + "  boolArray=<null>," + this.BR + "  charArray={" + this.BR + "    a," + this.BR + "    A" + this.BR + "  }," + this.BR + "  intArray=<null>," + this.BR + "  doubleArray=<null>," + this.BR + "  longArray=<null>," + this.BR + "  stringArray=<null>" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void intArray() {
        WithArrays wa = new WithArrays();
        wa.intArray = new int[]{1, 2};
        String exp = this.getClassPrefix(wa) + "[" + this.BR + "  boolArray=<null>," + this.BR + "  charArray=<null>," + this.BR + "  intArray={" + this.BR + "    1," + this.BR + "    2" + this.BR + "  }," + this.BR + "  doubleArray=<null>," + this.BR + "  longArray=<null>," + this.BR + "  stringArray=<null>" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void doubleArray() {
        WithArrays wa = new WithArrays();
        wa.doubleArray = new double[]{1.0, 2.0};
        String exp = this.getClassPrefix(wa) + "[" + this.BR + "  boolArray=<null>," + this.BR + "  charArray=<null>," + this.BR + "  intArray=<null>," + this.BR + "  doubleArray={" + this.BR + "    1.0," + this.BR + "    2.0" + this.BR + "  }," + this.BR + "  longArray=<null>," + this.BR + "  stringArray=<null>" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void longArray() {
        WithArrays wa = new WithArrays();
        wa.longArray = new long[]{1L, 2L};
        String exp = this.getClassPrefix(wa) + "[" + this.BR + "  boolArray=<null>," + this.BR + "  charArray=<null>," + this.BR + "  intArray=<null>," + this.BR + "  doubleArray=<null>," + this.BR + "  longArray={" + this.BR + "    1," + this.BR + "    2" + this.BR + "  }," + this.BR + "  stringArray=<null>" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void stringArray() {
        WithArrays wa = new WithArrays();
        wa.stringArray = new String[]{"a", "A"};
        String exp = this.getClassPrefix(wa) + "[" + this.BR + "  boolArray=<null>," + this.BR + "  charArray=<null>," + this.BR + "  intArray=<null>," + this.BR + "  doubleArray=<null>," + this.BR + "  longArray=<null>," + this.BR + "  stringArray={" + this.BR + "    a," + this.BR + "    A" + this.BR + "  }" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(wa));
    }

    @Test
    public void testLANG1319() {
        String[] stringArray = new String[]{"1", "2"};
        String exp = this.getClassPrefix(stringArray) + "[" + this.BR + "  {" + this.BR + "    1," + this.BR + "    2" + this.BR + "  }" + this.BR + "]";
        Assertions.assertEquals((Object)exp, (Object)this.toString(stringArray));
    }

    private String getClassPrefix(Object object) {
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    private String toString(Object object) {
        return new ReflectionToStringBuilder(object, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    static class Transaction {
        double amount;
        String date;

        Transaction(String datum, double betrag) {
            this.date = datum;
            this.amount = betrag;
        }
    }

    static class Account {
        Customer owner;
        List<Transaction> transactions = new ArrayList<Transaction>();

        Account() {
        }

        public double getBalance() {
            double balance = 0.0;
            for (Transaction tx : this.transactions) {
                balance += tx.amount;
            }
            return balance;
        }
    }

    static class Customer {
        String name;
        Bank bank;
        List<Account> accounts;

        Customer(String name) {
            this.name = name;
        }
    }

    static class Bank {
        String name;

        Bank(String name) {
            this.name = name;
        }
    }

    static class WithArrays {
        boolean[] boolArray;
        char[] charArray;
        int[] intArray;
        double[] doubleArray;
        long[] longArray;
        String[] stringArray;

        WithArrays() {
        }
    }
}

