/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.dbcp2.TesterConnection;

public class TesterDriver
implements Driver {
    private static final Properties validUserPasswords = new Properties();
    private static final String CONNECT_STRING = "jdbc:apache:commons:testdriver";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUser(String username, String password) {
        Properties properties = validUserPasswords;
        synchronized (properties) {
            validUserPasswords.put(username, password);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return CONNECT_STRING.startsWith(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertValidUserPassword(String user, String password) throws SQLException {
        if (user == null) {
            throw new SQLException("username cannot be null.");
        }
        Properties properties = validUserPasswords;
        synchronized (properties) {
            String realPassword = validUserPasswords.getProperty(user);
            if (realPassword == null) {
                throw new SQLException(user + " is not a valid username.");
            }
            if (!realPassword.equals(password)) {
                throw new SQLException(password + " is not the correct password for " + user + ".  The correct password is " + realPassword);
            }
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        TesterConnection conn = null;
        if (this.acceptsURL(url)) {
            String username = "test";
            String password = "test";
            if (info != null) {
                username = info.getProperty("user");
                password = info.getProperty("password");
                this.assertValidUserPassword(username, password);
            }
            conn = new TesterConnection(username, password);
        }
        return conn;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new TesterDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        validUserPasswords.put("foo", "bar");
        validUserPasswords.put("u1", "p1");
        validUserPasswords.put("u2", "p2");
        validUserPasswords.put("username", "password");
    }
}

